///////////////////////////////////////////////////////////////////////////////
// Sound occlusion, BABY!
///////////////////////////////////////////////////////////////////////////////
#include "Audio/AudioPCH.h"

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
SoundOcclusionTest::SoundOcclusionTest()
{
	ResetMaterialProperties();
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
SoundOcclusionTest::~SoundOcclusionTest()
{
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
void SoundOcclusionTest::ResetMaterialProperties()
{
	for (int i = 0; i < 256; i++)
	{
		materialProp[i].volumeFactor = 1.0f;
		materialProp[i].panFactor = 1.0f;
	}
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
void SoundOcclusionTest::SetMaterialProperty(
u8 material,
const MaterialProperty &prop)
{
	materialProp[material] = prop;
}

///////////////////////////////////////////////////////////////////////////////
// For a given listner and source, return the volume
// and pan multipliers (you don't have to initialize them)
///////////////////////////////////////////////////////////////////////////////
bool SoundOcclusionTest::Test(
Vector3CRef source,
Vector3CRef listener,
float &volumeFactor,
float &panFactor)
{
	// Always init these
	volumeFactor = 1.0f;
	panFactor = 1.0f;

	// Start the test
	if (!Begin(source, listener))
		return true;

	// Loop through each collision
	Vector3 intersection;
	u8 material;
	bool audible = true;
	while (audible && GetNext(intersection, material))
	{
		// look up the material in our list
		const MaterialProperty &m = materialProp[material];

		// Futz the factors
		ASSERT(!Math::Zero(m.volumeFactor));
		volumeFactor *= m.volumeFactor;
		panFactor *= m.panFactor;

		// Bail if we are down to no volume
		audible = !Math::Zero(volumeFactor);
	}

	// Tell them we are done
	End();

	return audible;
}

