///////////////////////////////////////////////////////////////////////////////
// Simple LFO's (low frequency oscillator)
///////////////////////////////////////////////////////////////////////////////
#include "Audio/function/lfo.h"
#include "Math/MathClass.h"

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
LFO::LFO()
{
	SetPeriod(1.0f);
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
LFO::LFO(
float amplitude,
float period) :
FunctionGenerator(amplitude)
{
	SetPeriod(period);
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
float LFO::Period()
{
	return Math::TwoPi / omega;
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
float LFO::Frequency()
{
	return omega / Math::TwoPi;
}

///////////////////////////////////////////////////////////////////////////////
// Set new values
///////////////////////////////////////////////////////////////////////////////
void LFO::SetPeriod(
float newPeriod)
{
	omega = Math::TwoPi / newPeriod;
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
void LFO::SetFrequency(
float newFrequency)
{
	omega = Math::TwoPi * newFrequency;
}

///////////////////////////////////////////////////////////////////////////////
// Evaluate
///////////////////////////////////////////////////////////////////////////////
float LFO::Evaluate(
float t)
{
	return Math::Sin(omega * t);
}

