///////////////////////////////////////////////////////////////////////////////
// Simple LFO's (low frequency oscillator)
///////////////////////////////////////////////////////////////////////////////
#include "Audio/function/ramp.h"
#include "Math/MathClass.h"

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
float RampDown::Evaluate(
float t)
{
	return 1.0f - Math::Clamp(t / p);
}


///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
float RampUp::Evaluate(
float t)
{
	return Math::Clamp(t / p);
}

