/***************************************************************************/
// SoundChannel2D
/***************************************************************************/
#include "Audio/AudioPCH.h"

/***************************************************************************/
/***************************************************************************/
SoundChannel2D::SoundChannel2D(
SoundEmitter &soundEmitter,
SoundDef &soundDef) :
SoundChannel(soundEmitter, soundDef)
{
	pan = 0.0f;
}

/***************************************************************************/
/***************************************************************************/
SoundChannel2D::~SoundChannel2D()
{
}

/***************************************************************************/
// Return we are 2D
/***************************************************************************/
SoundChannel::TYPE SoundChannel2D::Type()
{
	return CHANNEL2D;
}

/***************************************************************************/
// Allow them to set the pan
/***************************************************************************/
void SoundChannel2D::SetPan(float newPan)
{
	pan = Math::Clamp(newPan, -1.0f, 1.0f);
 	ApplyPan();
}

/***************************************************************************/
/***************************************************************************/
void SoundChannel2D::ApplyPan()
{
	// But do the pan too!
	if (voice)
		voice->SetPan(pan);
}

/***************************************************************************/
/***************************************************************************/
void SoundChannel2D::ApplySettings()
{
	SoundChannel::ApplySettings();
	ApplyPan();
}
