///////////////////////////////////////////////////////////////////////////////
// SoundStream, a disk or i/o based sound
// Abstract base class
///////////////////////////////////////////////////////////////////////////////
#include "Audio/AudioPCH.h"

// Overrides
float SoundStream::m_masterPitch = 0.0f;

///////////////////////////////////////////////////////////////////////////////
// Set the overall pitch for all sounds
///////////////////////////////////////////////////////////////////////////////
void SoundStream::SetMasterPitch(
float pitch)
{
	m_masterPitch = pitch;
}

///////////////////////////////////////////////////////////////////////////////
// Get the overall pitch for all sound
///////////////////////////////////////////////////////////////////////////////
float SoundStream::GetMasterPitch()
{
	return m_masterPitch;
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
SoundStream::SoundStream(
const char *name,
SoundAttr &attr,
bool loop) :
m_attr(attr)
{
	// Save off our name
	strncpy(m_name, name, sizeof(m_name) - 1);
	m_name[sizeof(m_name) - 1] = '\0';

	m_loop = loop;

	m_paused = false;

	m_caps = 0;

	m_fader = NULL;
	m_volume = 1.0f;
	m_pan = 0.0f;
	m_pitch = 0.0f;
	m_wet = 0.0f;
	m_dry = 1.0f;
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
SoundStream::SoundStream(
const char *name,
bool loop)
{
	// Save off our name
	strncpy(m_name, name, sizeof(m_name) - 1);
	m_name[sizeof(m_name) - 1] = '\0';

	m_loop = loop;

	m_paused = false;

	m_caps = 0;

	m_fader = NULL;
	m_volume = 1.0f;
	m_pan = 0.0f;
	m_pitch = 0.0f;
	m_wet = m_dry = 0.0f;
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
bool SoundStream::Pause()
{
	// Are we already paused
	if (m_paused)
		return false;

	// Stop the stream without rewinding
	if (!Stop(false))
		return false;

	// We are paused now
	m_paused = true;
	return true;
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
bool SoundStream::Unpause()
{
	// Are we paused
	if (!m_paused)
		return false;

	// Stop the stream without rewinding
	if (!Play())
		return false;

	// We are paused now
	m_paused = false;
	return true;
}
