///////////////////////////////////////////////////////////////////////////
//
//  Draw.h
//
//  Draw Rendering Module (immediate mode drawing).
//
//  Nate Robins, September 2000.
//
//  Copyright (c) 2000 Avalanche Software.
//
////////////////////////////////////////////////////////////////////////////

#ifndef DRAW_H
#define DRAW_H


////////////////////////////////////////////////////////////////////////////
//  Includes
////////////////////////////////////////////////////////////////////////////

#include "Display/Common/DrawArray.h"


#ifdef __cplusplus
extern "C" {
#endif


////////////////////////////////////////////////////////////////////////////
//  Defines
////////////////////////////////////////////////////////////////////////////

enum
{
//	D_POINTS	= DA_POINTS,
	D_LINES     = DA_LINES,
	D_LINESTRIP = DA_LINESTRIP,
	D_LINELOOP  = DA_LINELOOP,
	D_TRIANGLES = DA_TRIANGLES,
	D_TRISTRIP  = DA_TRISTRIP,
//	D_TRIFAN    = DA_TRIFAN,
	D_QUADS     = DA_QUADS,
};


////////////////////////////////////////////////////////////////////////////
//  Types
////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////
//  Globals
////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////
//  Macros
////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////
//  Functions
////////////////////////////////////////////////////////////////////////////

void Draw__Begin( int primitive );
void Draw__End( void );

////////////////////////////////////////////////////////////////////////////

void Draw__Vector( float x, float y, float z );
void Draw__Normal( float i, float j, float k );
void Draw__Color( float red, float green, float blue, float alpha );
void Draw__TexCoord( float u, float v );


////////////////////////////////////////////////////////////////////////////

#ifdef __cplusplus
}
#endif

#endif	// DRAW_H
