///////////////////////////////////////////////////////////////////////////
//
//  MatrixStack.h
//
//  MatrixStack Rendering Module.
//
//  Nate Robins, September 2000.
//
//  Copyright (c) 2000 Avalanche Software.
//
////////////////////////////////////////////////////////////////////////////

#ifndef MATRIXSTACK_H
#define MATRIXSTACK_H


////////////////////////////////////////////////////////////////////////////
//  Includes
////////////////////////////////////////////////////////////////////////////

#include "platform/CompilerControl.h"
#include "Math/Matrix.h"

#ifdef GCN
#include <dolphin/mtx.h>
#endif

////////////////////////////////////////////////////////////////////////////
//  Defines
////////////////////////////////////////////////////////////////////////////

enum
{
    MS_PROJECTION = 0,
    MS_MODELVIEW,
    MS_TEXTURE,

#if defined(DIRECTX)
	 MS_TEXTURE1,
	 MS_TEXTURE2,
	 MS_TEXTURE3,
#endif

	 MS_NUM_STACKS		// must be last
};

#define MS_MATRIX_STACK_DEPTH	3	// can be increased if needed

////////////////////////////////////////////////////////////////////////////
//  Types
////////////////////////////////////////////////////////////////////////////

/* for viewport manipulation-- supports split-screen, for one thing */

struct ts_Viewport
{
	float	fX;		// 0.0 to 1.0, fraction of current screen width
	float	fY;		// 0.0 to 1.0, fraction of current screen height
	float	fWidth;	// 0.0 to 1.0, fraction of current screen width
	float	fHeight;	// 0.0 to 1.0, fraction of current screen height
};

////////////////////////////////////////////////////////////////////////////
//  Macros
////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////
//  Global variables
////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////
//  Functions
////////////////////////////////////////////////////////////////////////////

#ifdef GCN
void MatrixStack__Init( void);
void MatrixStack__LoadMany( u32 iMatrices, Mtx *m, Mtx *mi);
void MatrixStack__Matrix4x4ToMtx( Matrix4x4 *pMtx44, MtxPtr mtx);
#elif defined( DIRECTX)
bool MatrixStack__IsIdentity( int mode );
#endif

////////////////////////////////////////////////////////////////////////////

void MatrixStack__InitViewportMatrix(void);

////////////////////////////////////////////////////////////////////////////

void MatrixStack__Identity( void ) NAMED_SECTION("text.rend1");

////////////////////////////////////////////////////////////////////////////

void MatrixStack__Load( Matrix4x4* m );

////////////////////////////////////////////////////////////////////////////

void MatrixStack__Multiply( Matrix4x4* m );

////////////////////////////////////////////////////////////////////////////

void MatrixStack__Scale( float x, float y, float z );

////////////////////////////////////////////////////////////////////////////

void MatrixStack__Translate( float x, float y, float z );

////////////////////////////////////////////////////////////////////////////

void MatrixStack__LookAt( float eyex, float eyey, float eyez, float lookx, float looky, float lookz, float upx, float upy, float upz );

////////////////////////////////////////////////////////////////////////////

void MatrixStack__Perspective( float fovy, float aspect, float znear, float zfar );

////////////////////////////////////////////////////////////////////////////

void MatrixStack__Orthographic( float left, float right, float top, float bottom, float znear, float zfar );

////////////////////////////////////////////////////////////////////////////

void MatrixStack__Viewport(ts_Viewport *pViewport);
void MatrixStack__FullScreenViewport(void);
void MatrixStack__ViewportPixels(u32 u32X, u32 u32Y, u32 u32Width, u32 u32Height);

////////////////////////////////////////////////////////////////////////////

void MatrixStack__Push( void );

////////////////////////////////////////////////////////////////////////////

void MatrixStack__Pop( void );

////////////////////////////////////////////////////////////////////////////

void MatrixStack__Mode( int mode ) NAMED_SECTION("text.rend1");

////////////////////////////////////////////////////////////////////////////

Matrix4x4 *MatrixStack__Get( int mode ) NAMED_SECTION("text.rend1");

#ifdef PS2
Graphics4x4 *MatrixStack__GetViewport(void);
Matrix4x4 *MatrixStack__GetCameraToScreen(void);
#endif //PS2

////////////////////////////////////////////////////////////////////////////

#endif  // MATRIXSTACK_H
