/**********************************************/
/*                                            */
/* SceneView.h                                */
/* big juju prototype  12/20/01               */
/* ned martin  avalanche software             */
/* visual c++ 6.0                             */
/* view frustum management for scenes         */
/*                                            */
/**********************************************/

/* the view class is provided so that each scene can have it's own view characteristics. the main job of the view is to
define the view frustum for the scene (aspect ratio, fov, near and far clip, fog start and end). the DisplayState record
has default settings, typically set up by processing the light.var script file. each CScene record has a SceneView,
member, which is initialized to the deafult settings in DisplayState when the scene is registered, but from then on it is
independent-- changing the DisplayState settings will not update the independent views */

#ifndef __SCENEVIEW_H
#define __SCENEVIEW_H

/* system includes */

/* engine includes */

#include "Layers/LayersStruct.h"				// for ts_bRGBA
#include "Display/Common/MatrixStack.h"	// for ts_Viewport
#include "Game/Misc/Frustum.h"				// for ts_Frustum

/******************* forward declarations ****************/

/******************* defines *****************************/

/******************* macros ******************************/

/******************* structures **************************/

/******************* global variables ********************/

/******************* global prototypes *******************/

/******************* forward declarations ****************/

/******************* class *******************************/

class CSceneView
{
// Constructor/destructor

public:

	CSceneView();
	~CSceneView() {}

// Implementation-- data

protected:

	float				m_fNearClip;			// in meters
	float				m_fFarClip;				// in meters
	float				m_fFieldOfViewY;		// in degrees
	float				m_fAspectRatio;
	float				m_fNearFog;				// in meters
	float				m_fFarFog;				// in meters
	bool				m_bFog;					// fog on or off
	ts_bRGBA			m_FogColor;
	int				m_nFogMode;				// RS_FOGMODE_LINEAR, for example
	float				m_fFogDensity;			// 0.0 to 1.0

	/* projection matrix for this scene view */

	Matrix4x4		m_mProjection;
	bool				m_bProjectionDirty;	// if TRUE, need to recalculate projection matrix

	/* viewport for this scene view */

	ts_Viewport		m_Viewport;
	bool				m_bValidViewport;		// if TRUE, m_Viewport is valid, and can be used to set viewport

	/* size of viewport into frame buffer, in pixels. on the ps2, this is needed for setting up the guard band */
	/* frustum. for rendering into a texture, this is size of texture. for game view scenes, this is the size */
	/* of the frame buffer, affected by the viewport settings */

	int				m_nViewportWidth;		// in pixels
	int				m_nViewportHeight;	// in pixels

	/* frustum generated by above values. on ps2 we also have a guard band frustum to help with clipping */

	bool				m_bFrustumDirty;		// flag whether frustum needs to be rebuilt
	ts_Frustum		m_ViewFrustum;
#ifdef PS2
	ts_Frustum		m_GuardBandFrustum;
#endif //PS2

	/* for clearing frame buffer before scene is rendered */

	ts_bRGBA			m_ClearColor;
	u32				m_u32ClearMode;		// combination of RS_COLOR_BUFFER_BIT and RS_DEPTH_BUFFER_BIT

	/* flag for telling when we are within Render routine */

	bool				m_bInRender;

	/* for supporting UpdateFog routine-- see notes at routine */

	bool				m_bFogWhenFrustumBuilt;
	bool				m_bFarFogPlaneValid;
	bool				m_bNearFogPlaneValid;

// Implementation-- code

public:

	/* simple routines */

	void SetNearClip(float fMeters)				{ if (m_fNearClip != fMeters) { m_fNearClip = fMeters; m_bFrustumDirty = true; m_bProjectionDirty = true;} }
	void SetFarClip(float fMeters)				{ if (m_fFarClip != fMeters) { m_fFarClip = fMeters; m_bFrustumDirty = true; m_bProjectionDirty = true;} }
	void SetFieldOfViewY(float fDegrees)		{ if (m_fFieldOfViewY != fDegrees) { m_fFieldOfViewY = fDegrees; m_bFrustumDirty = true; m_bProjectionDirty = true;} }
	void SetAspectRatio(float fValue)			{ if (m_fAspectRatio != fValue) { m_fAspectRatio = fValue; m_bFrustumDirty = true; m_bProjectionDirty = true;} }
	void SetNearFog(float fMeters)				{ if (m_fNearFog != fMeters) { m_fNearFog = fMeters; m_bFrustumDirty = true; } }
	void SetFarFog(float fMeters)					{ if (m_fFarFog != fMeters) { m_fFarFog = fMeters; m_bFrustumDirty = true; } }
	void SetFog(bool bEnable)						{ if (m_bFog != bEnable) { m_bFog = bEnable; m_bFrustumDirty = true; } }
	void SetFogColor(ts_bRGBA Color)				{ m_FogColor = Color; }
	void SetFogMode(int nFogMode)					{ m_nFogMode = nFogMode; }
	void SetFogDensity(float fFogDensity)		{ ASSERT((fFogDensity >= 0.0f) && (fFogDensity <= 1.0f)); m_fFogDensity = fFogDensity; }
	void SetClearColor(ts_bRGBA Color)			{ m_ClearColor = Color; }

	float GetNearClip(void)							{ return(m_fNearClip); }
	float GetFarClip(void)							{ return(m_fFarClip); }
	float GetFieldOfViewY(void)					{ return(m_fFieldOfViewY); }
	float GetAspectRatio(void)						{ return(m_fAspectRatio); }
	float GetNearFog(void)							{ return(m_fNearFog); }
	float GetFarFog(void)							{ return(m_fFarFog); }
	bool GetFog(void)									{ return(m_bFog); }
	ts_bRGBA GetFogColor(void)						{ return(m_FogColor); }
	ts_bRGBA GetClearColor(void)					{ return(m_ClearColor); }
	u32 GetClearMode(void)							{ return(m_u32ClearMode); }

	ts_Frustum *GetViewFrustum(void)				{ return(&m_ViewFrustum); }
	ts_Viewport *GetViewport(void)				{ return(&m_Viewport); }
#ifdef PS2
	ts_Frustum *GetGuardBandFrustum(void)		{ return(&m_GuardBandFrustum); }
#endif //PS2

	bool InRender()									{ return(m_bInRender); }

	/* routines defined in .cpp */

	void Render();									// implement settings for rendering
	void ClearFrameBuffer();					// clear frame buffer using color and mode settings
	void UpdateFog(bool bFog);					// update frustum settings when fog status changes during scene
	void SetClearMode(bool bClearColorBuffer);
	void SetViewport(float fX, float fY, float fWidth, float fHeight);
	void SetViewport(int nWidth, int nHeight);
	void ResetViewport();
	Matrix4x4 &GetProjection();

protected:

	void BuildViewFrustum();	// build view frustum out of settings

// operations

public:

};

#endif // __SCENEVIEW_H

