#ifndef __STREAM_FLAGS_H
#define __STREAM_FLAGS_H

enum StreamFlags
{
	STFLAG_POSITION4					= 0x00000001,
	STFLAG_NORMAL						= 0x00000002,
	STFLAG_BINORMAL					= 0x00000004,
	STFLAG_COLOR_CHANNELS_MASK		= 0x00000F00,
	STFLAG_COLOR_CHANNELS_SHIFT	= 0x08,

	STFLAG_TEXTURE_CHANNELS_MASK	= 0x0000F000,
	STFLAG_TEXTURE_CHANNELS_SHIFT	= 0x0C,

	STFLAG_DUMMY_COLOR_MASK			= 0x000F0000,
	STFLAG_DUMMY_COLOR_SHIFT		= 0x10,

	STFLAG_DUMMY_TEXTURE_MASK		= 0x0FF00000,
	STFLAG_DUMMY_TEXTURE_SHIFT		= 0x14
} ;

inline unsigned int textureChannels( unsigned int flags )				{ return (flags & STFLAG_TEXTURE_CHANNELS_MASK) >> STFLAG_TEXTURE_CHANNELS_SHIFT; }

#endif
