////////////////////////////////////////////////////////////////////////////
//
//  Platform.c
//
//  Platform Specific Module.
//
//  Nate Robins, September 2000.
//
//  Copyright (c) 2000 Avalanche Software.
//
////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////
//  Includes
////////////////////////////////////////////////////////////////////////////

#include "Display/DisplayPCH.h"





////////////////////////////////////////////////////////////////////////////
//  Types
////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////
//  Globals
////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////
//  Prototypes
////////////////////////////////////////////////////////////////////////////

static bool PS2RendererOutOfMemCallback(u32 size, u32 align);

////////////////////////////////////////////////////////////////////////////
//  Functions
////////////////////////////////////////////////////////////////////////////

void Platform__Init( void )
{
	memAddOutOfMemCallback(PS2RendererOutOfMemCallback);
}

////////////////////////////////////////////////////////////////////////////

void Platform__Destroy( void )
{
	memRemoveOutOfMemCallback(PS2RendererOutOfMemCallback);
}

////////////////////////////////////////////////////////////////////////////

// TJC - Ok, Im not sure where to put these so here looks good..
void* PS2RendererMalloc(u_int size)
{
	MEM_SET_RETURN_ADDRESS();
	return memAlloc(size, false);
}

void* PS2RendererMemAlign(u_int alignment, u_int size)
{
	MEM_SET_RETURN_ADDRESS();
	return memAlloc(size, alignment, false);
}

void PS2RendererFree(void* block)
{
	memFree(block);
}

bool PS2RendererCouldAlloc(u_int alignment, u_int size)
{
	return memCouldAlloc(size, alignment, false);
}

bool PS2RendererOutOfMemCallback(u32 size, u32 align)
{
	return MasterList::TryToFreeMemory(size);
}

