//
// Author: Tyler Colbert
//
// Here lie all the static objects that represent the
// handlers, and the code ot add them to the renderer
//
// officially, AddHandlers() is part of the renderer.
// it exists in the renderers namespace to keep from
// interfering with outside code.  Every thing else
// in this file should be static.
//
// this file should be the only place in the renderer
// that you have to touch to add a new handler.
//

//#include "PS2Renderer.h"


/////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////
// include files for handlers
// I wish that these could go in the namespace incase they define global
// functions/variables.	we dont want them to conflict with the game.  However
// namespace std is used by them... and codewarrior doesnt want to let it compile
// that way...
/////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////
#include "VUStaticData31.h"
#include "VUAnimData.h"
#include "VUColorSetData.h"

// this code block exists in the renderers namespace as it is only called by the
// renderer (and thus is part of the renderer).  See the comment...
namespace PS2Renderer {

	/////////////////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////////////////
	// private renderer function declarations
	/////////////////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////////////////

	// add a handler to the renderer
	extern void AddHandler(VUDataClass* handler);
	void AddHandlers(void);


	/////////////////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////////////////
	// static handler objects
	/////////////////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////////////////

	static VUStaticData31 	StaticHandler;
	static VUAnimData			AnimHandler;
	static VUColorSetData	ColorSetHandler;

	/////////////////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////////////////
	// Function called by the PS2Renderer...
	/////////////////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////////////////

	void AddHandlers(void)
	{
		AddHandler(&StaticHandler);
		AddHandler(&AnimHandler);
		AddHandler(&ColorSetHandler);
	}
}
