#ifndef __VU_RENDER_INFO_H
#define __VU_RENDER_INFO_H

// in the light data, the colors are represented as
// floats ranging from 0.0f - 128.0f
typedef struct _PS2LightData
{
	bool 							mEnabled;

	// these are values from PS2Renderer.h LIGHT_SPACE_*
	u_int							mFlags;
	u_int							mCurrentSpace;
	u_int							mType;
	float							mQuadraticAttenuation;

	union
	{
		PS2Vector4					mOriginalPosition;
		PS2Vector4					mOriginalDirection;
	}mOrigVec;

	union
	{
		PS2Vector4					mCurrentPosition;
		PS2Vector4					mCurrentDirection;
	}mCurVec;

	PS2Vector4					mDiffuseColor;
	PS2Vector4					mAmbientColor;
	PS2Vector4					mSpecularColor;
} PS2LightData;

typedef struct _PS2AmbientLightData
{
	bool 							mEnabled;
	PS2Vector4 					mColor;
} PS2AmbientLightData;

typedef struct _PS2Lights
{
	PS2LightData				mLight[MAX_LIGHTS];
	PS2AmbientLightData		mAmbientLight;
	PS2Vector4					mTotalAmbientLight;
} PS2Lights;

enum EnvMapType
{
	ENVMAP_TYPE_STD_ENV_MAP = 0,
	ENVMAP_TYPE_STD_SPHERE_MAP,
	ENVMAP_TYPE_REF_ENV_MAP,
	ENVMAP_TYPE_REF_SPHERE_MAP
} ;

typedef struct _PS2EnvMapData
{
	EnvMapType					mType;
	EnvMapSpace					mSpace;

	u_int							mEVMapTextureBind;				// Bind ID ( 0 = Mapping Off )

	PS2Vector4					mEyePosition;					// Reflevtive: Eye in Reflect Space
	const PS2Matrix4x4 *		mWorldToMap;					// Reflective: World-Sphere Transform
	const PS2Matrix4x4 *		mPostTransform;				// Non-Reflective: Post Transform (Coordinate Transform)
	PS2Matrix4x4				mFinalTransform;				// Final Transform
} PS2EnvMapData;

typedef struct _VURenderInfo
{
	u_int				drawFlags;						// flags that came in with Draw( ) call (defined in PS2Renderer.h)
	u_int				lclFlags;						// flags generated by PS2Renderer (defined below, prefix: LCL_)

	// these flags are initially filled in by the handlers getRequirementsFlags() method
	// the renderer then updates them to reflect what it passed to the handler before
	// calling the handlers prepDMA() method.
	u_int				requirementsFlags;			// defined below, prefix REQ_
	u_int				validMatricies;				// defined below, prefix MATRIX_
	u_int				lightSpaceRequested;			// defined in PS2Renderer.h, prefix LIGHT_SPACE_

	float				alphaMultiplier;				// constant Alpha multiplier

	float				fogNear, fogFar;				// fog Values

	u_char			ShadowR, ShadowG, ShadowB;	// Shadow Color
	
	PS2Lights		mLights;
	PS2EnvMapData	mEnvData;

	// nice little identity
	PS2Matrix4x4	mIdentity;

	// generated for clip codes
	PS2Matrix4x4	mWorldToClip;
	PS2Matrix4x4	mCameraToClip;
	PS2Matrix4x4	mViewToClip;
	PS2Matrix4x4	mScreenToClip;
	PS2Matrix4x4	mClipToScreen;
	
	// generated for cull codes
	PS2Matrix4x4	mWorldToCull;
	PS2Matrix4x4	mCameraToCull;
	PS2Matrix4x4	mViewToCull;
	PS2Matrix4x4	mScreenToCull;
	PS2Matrix4x4	mCullToScreen;
	
	// generated for non-clip codes
	PS2Matrix4x4	mWorldToScreen;
	PS2Matrix4x4	mCameraToScreen;
	PS2Matrix4x4	mViewToScreen;
	
	// generated intermediate matrices used for lighting & culling
	PS2Matrix4x4	mClipToView;
	PS2Matrix4x4	mCullToView;
	PS2Matrix4x4	mWorldToView;
	PS2Matrix4x4	mViewToWorld;
	PS2Matrix4x4	mViewToCamera;
	PS2Matrix4x4	mCameraToWorld;
	
	// passed matrices that are not above
	PS2Matrix4x4	mWorldToCamera;
	PS2Matrix4x4	mCameraToView;

	// inverse model matricies
	PS2Matrix4x4	mViewToModel;
	PS2Matrix4x4	mCameraToModel;
	PS2Matrix4x4	mWorldToModel;
	
	// TC transformation matrix
	PS2Matrix4x4	mTexture;
	
	bool 				lightsOn( void ) const
	{
		for( unsigned int light = 0; light < MAX_LIGHTS; light++)
			if( mLights.mLight[light].mEnabled)
				return true;
				
		return false;
	}
	
	void				countLights( unsigned int &numPoint, unsigned int &numDirectional)
	{
		numPoint = numDirectional = 0;
		
		for( unsigned int light = 0; light < MAX_LIGHTS; light++)
		{
			if( mLights.mLight[light].mEnabled )
				switch( mLights.mLight[light].mType )
				{
				case LIGHT_TYPE_DIRECTIONAL:
					numDirectional++;
					break;

				case LIGHT_TYPE_POINT:
					numPoint++;
					break;
				}
		}
	}			
	
} VURenderInfo;


#endif