#include "Game/GamePCH.h"

namespace ParticulateMgr
{
	DoublyLinkedList<System> sSystems(false);
	DoublyLinkedList<Effect> sEffects(false);
	static bool sRenderEnabled = true;


	////////////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////////////
	//// :: routines
	////////////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////////////

	void Update(float absTime)
	{
		// no point in this if we aren't rendering...
		if(!sRenderEnabled)
			return;

		Effect* effect = sEffects.Head();
		while(effect)
		{
			effect->Update(absTime);
			effect = effect->next;
		}

		System* system = sSystems.Head();
		while(system)
		{
			system->Update(absTime);
			system = system->next;
		}
	}

	////////////////////////////////////////////////////////////////////////////////////////////////

	void Render(float absTime)
	{
		if(!sRenderEnabled)
			return;

		System* system = sSystems.Head();
		while(system)
		{
			system->Render(absTime);
			system = system->next;
		}
	}


	////////////////////////////////////////////////////////////////////////////////////////////////

	void RenderDisable()
	{
		sRenderEnabled = false;
	}

	////////////////////////////////////////////////////////////////////////////////////////////////

	void RenderEnable()
	{
		sRenderEnabled = true;
	}

	////////////////////////////////////////////////////////////////////////////////////////////////

	bool RenderEnabled()
	{
		return sRenderEnabled;
	}

	////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef CDROM
	void Test(void)
	{
		TestClass testme;
		testme.Run();
	}
#endif
};

