// THIS IS IN THE NAMESPACE 'ParticulateMgr'


//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//// FloatRange:: inlines
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////

inline FloatRange::FloatRange()
{
}

//////////////////////////////////////////////////////////////////////////////////

inline FloatRange::FloatRange(float daMin, float daMax) : 
mMin(daMin), mMax(daMax)
{
}

//////////////////////////////////////////////////////////////////////////////////

inline float FloatRange::Random()
{
	return g_random.InRange(mMin, mMax);
}

//////////////////////////////////////////////////////////////////////////////////

inline bool FloatRange::AlwaysZero()
{
	return Math::Zero(mMin) && Math::Zero(mMax);
}

//////////////////////////////////////////////////////////////////////////////////

inline void FloatRange::Set(float val)
{
	mMin = mMax = val;
}

//////////////////////////////////////////////////////////////////////////////////

inline void FloatRange::Set(float minimum, float maximum)
{
	mMin = minimum; mMax = maximum;
}

//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//// FloatSpline:: inlines
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////

inline FloatSpline::FloatSpline()
{
}

//////////////////////////////////////////////////////////////////////////////////

inline FloatSpline::FloatSpline(float constant)
{
	mPoints[0] = mPoints[1] = mPoints[2] = mPoints[3] = constant;
}

//////////////////////////////////////////////////////////////////////////////////

inline FloatSpline::FloatSpline(float initial, float final)
{
	mPoints[0] = initial;
	mPoints[3] = final;
	mPoints[1] = initial*0.666666f + final*0.333333f;
	mPoints[2] = final*0.666666f + initial*0.333333f;
}

//////////////////////////////////////////////////////////////////////////////////

inline FloatSpline::FloatSpline(float point0, float point1, float point2, float point3)
{
	mPoints[0] = point0;
	mPoints[1] = point1;
	mPoints[2] = point2;
	mPoints[3] = point3;
}

//////////////////////////////////////////////////////////////////////////////////

inline float FloatSpline::GetValue(float fT)
{
	float fTsq = fT * fT;
	float oM = 1.0f - fT;
	float oMsq = oM * oM;
	return 
		mPoints[0] * fTsq * fT +
		mPoints[1] * fTsq * oM +
		mPoints[2] * oMsq * fT +
		mPoints[3] * oMsq * oM;
}

//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//// Cone:: inlines
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////

inline Cone::Cone()
{
}

//////////////////////////////////////////////////////////////////////////////////

inline Cone::Cone(Vector3CRef daDirection, float daInnerAngle, float daOuterAngle, const FloatRange& daConeScale) :
	mDirection(daDirection), 
	mInnerAngle(daInnerAngle), 
	mOuterAngle(daOuterAngle),
	mConeScale(daConeScale)
{
}

//////////////////////////////////////////////////////////////////////////////////

inline Vector3 Cone::Random()
{
	return g_random.InCone(mDirection, mInnerAngle, mOuterAngle) * mConeScale.Random();
}

//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//// ColorEnvelope:: inlines
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////

inline ColorEnvelope::ColorEnvelope()
{
}

//////////////////////////////////////////////////////////////////////////////////

inline ColorEnvelope::ColorEnvelope(Vector4CRef splinepoint1, Vector4CRef splinepoint2, Vector4CRef splinepoint3, Vector4CRef splinepoint4)
{
	mSplinePoints[0] = splinepoint1;
	mSplinePoints[1] = splinepoint2;
	mSplinePoints[2] = splinepoint3;
	mSplinePoints[3] = splinepoint4;
}

inline ColorEnvelope::ColorEnvelope(Vector4CRef color)
{
	mSplinePoints[0] = color;
	mSplinePoints[1] = color;
	mSplinePoints[2] = color;
	mSplinePoints[3] = color;
}
inline ColorEnvelope::ColorEnvelope(Vector4CRef initial, Vector4CRef final)
{
	mSplinePoints[0] = initial;
	mSplinePoints[1] = initial * 0.6666f + final * 0.3333f;
	mSplinePoints[2] = initial * 0.3333f + final * 0.6666f;
	mSplinePoints[3] = final;
}

//////////////////////////////////////////////////////////////////////////////////

inline Vector4 ColorEnvelope::GetColor(float fT)
{
	float fTSquared = fT * fT;
	float fOneMinusT = (1.0f - fT);
	float fOneMinusTSquared = fOneMinusT * fOneMinusT;
	return
		(fOneMinusTSquared * fOneMinusT * mSplinePoints[0]) + 
		(fOneMinusTSquared * fT * mSplinePoints[1]) +
		(fOneMinusT * fTSquared * mSplinePoints[2]) +
		(fTSquared * fT * mSplinePoints[3]);
}

//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//// ParticulateSet:: inlines
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////

inline ParticulateSet::ParticulateSet() :
	mFirstIndex(0),
	mIndexAfterLast(0)
{
}

//////////////////////////////////////////////////////////////////////////////////

inline s32 ParticulateSet::GetSize() const
{
	return mIndexAfterLast - mFirstIndex;
}

//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//// Emitter:: inlines
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////

inline int Emitter::Count() const
{
	return mParticulates.GetSize();
}

////////////////////////////////////////////////////////////////////////////////////////////////

inline bool Emitter::IsEmpty() const
{
	return Count() == 0;
}

////////////////////////////////////////////////////////////////////////////////////////////////

inline bool Emitter::IsFirst() const
{
	return prev == NULL; 
}

////////////////////////////////////////////////////////////////////////////////////////////////

inline bool Emitter::IsLast() const
{
	return next == NULL;
}

////////////////////////////////////////////////////////////////////////////////////////////////

inline s32 Emitter::CanMoveUp() const
{
	s32 newpos = mParticulates.mIndexAfterLast+1;
	s32 space;
	if ( IsLast() )
		space = MAX_PARTICULATES_PER_SYSTEM - mParticulates.mIndexAfterLast;
	else
		space = next->mParticulates.mFirstIndex - mParticulates.mIndexAfterLast;
	if(space < 0)
		return 0;
	return space;
}

////////////////////////////////////////////////////////////////////////////////////////////////

inline s32 Emitter::CanMoveDown() const
{
	if ( IsFirst() )
		return mParticulates.mFirstIndex;

	s32 space = mParticulates.mFirstIndex	- prev->mParticulates.mIndexAfterLast;
	if(space < 0)
		return 0;
	return space;
}

////////////////////////////////////////////////////////////////////////////////////////////////

inline void Emitter::ShiftUp(s32 count)
{
	ASSERT(CanMoveUp() >= count);
	while(count--)
	{
		mSystem->mBuffer[mParticulates.mIndexAfterLast++] = 
			mSystem->mBuffer[mParticulates.mFirstIndex++];
	}
}

////////////////////////////////////////////////////////////////////////////////////////////////

inline void Emitter::ShiftDown(s32 count)
{
	ASSERT(CanMoveDown() >= count);
	while(count--)
	{
		mSystem->mBuffer[--mParticulates.mFirstIndex] = 
			mSystem->mBuffer[--mParticulates.mIndexAfterLast];
	}
}

////////////////////////////////////////////////////////////////////////////////////////////////

inline bool Emitter::operator> (const Emitter& rhs) const
{
	return mParticulates.mFirstIndex > rhs.mParticulates.mFirstIndex;
}

////////////////////////////////////////////////////////////////////////////////////////////////

inline bool Emitter::operator< (const Emitter& rhs) const
{
	return mParticulates.mFirstIndex < rhs.mParticulates.mFirstIndex;
}


