///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
void OSThread::Start(Priority pri)
{
	OSInitThreadQueue( &m_threadQueue);

	OSPriority	gcnPri;

	if(	( pri < OSThread::VERY_LOW) ||
			( pri > OSThread::VERY_HIGH))
	{
		pri = OSThread::VERY_LOW;
	}

	gcnPri = ( ( OSThread::VERY_HIGH - pri) + 2) * 4;
	if( OSCreateThread(	&m_thread,
								ThreadEntry,
								this,
								m_stack + OSThread::STACK_SIZE,
								OSThread::STACK_SIZE,
								gcnPri,
								OS_THREAD_ATTR_DETACH))
	{
		m_running = true;
		OSResumeThread( &m_thread);
	}
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
void OSThread::WaitTillDone()
{
	while( m_running)
	{
		OSSleepThread( &m_threadQueue);
	}
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
void OSThread::Terminate()
{
	m_running = false;
	OSWakeupThread( &m_threadQueue);
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
OSThread::OSThread()
{
	m_running = false;
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
OSThread::~OSThread()
{
	ASSERT(!m_running);
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
void OSThread::Kill()
{
	OSCancelThread( &m_thread);
	OSWakeupThread( &m_threadQueue);
	m_running = false;
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
bool OSThread::IsRunning()
{
	return( m_running);
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
void * OSThread::ThreadEntry( void *pParam)
{
	OSThread		*pThreadObj = (OSThread *)pParam;

	OSSetThreadSpecific( 0, pParam);

	pThreadObj->Run();
	pThreadObj->Terminate();

	return( NULL);
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
void OSThread::DelayThread( u32 milliSecs)
{

	OSThread		*pThreadObj;

	pThreadObj = (OSThread *)OSGetThreadSpecific( 0);
	OSCreateAlarm( &pThreadObj->m_alarm);
	OSSetAlarmTag( &pThreadObj->m_alarm, (u32)pThreadObj);
	OSSetAlarm(	&pThreadObj->m_alarm,
					OSMillisecondsToTicks( milliSecs),
					OSThread::ThreadAlarmHandler);

	OSSleepThread( &pThreadObj->m_threadQueue);
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
void OSThread::ThreadAlarmHandler( OSAlarm *pAlarm, OSContext *pContext)
{

	OSThread		*pThreadObj;

	pThreadObj = (OSThread *)pAlarm->tag;
	OSWakeupThread( &pThreadObj->m_threadQueue);
}
