///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
#include <eekernel.h>

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
OSThread::OSThread()
{
  	m_threadID = -1;
	m_dieNow = false;
}

///////////////////////////////////////////////////////////////////////////////
// Don't delete unless you KIll(true)
///////////////////////////////////////////////////////////////////////////////
OSThread::~OSThread()
{
	ASSERT(m_threadID <= 0);
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
bool OSThread::Start(Priority pri)
{
	// thread already started?
	ASSERT(m_threadID < 0);

	// Compute the priority
	int ps2priority = (VERY_HIGH - pri) + 8;

#ifdef _DEBUG
	// Clear the stack
	memset(m_stack, 0, sizeof(m_stack));
#endif

	// Setup the paramters
	struct ThreadParam threadParam;
	threadParam.entry = &ThreadEntry;
	threadParam.stack = &m_stack[0];
	threadParam.stackSize = STACK_SIZE;
	threadParam.initPriority = ps2priority;
	threadParam.gpReg = &_gp;
	threadParam.option = 0;

	m_threadID = CreateThread(&threadParam);
	ASSERT(m_threadID >= 0);
	if (m_threadID < 0)
		return false;

	StartThread(m_threadID, this);
	return true;
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
void OSThread::WaitForExit()
{
	while (m_threadID >= 0)
		::DelayThread(1);
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
void OSThread::Kill(bool wait)
{
	if (m_threadID >= 0)
	{
		SignalDeath();
		if (wait)
			WaitForExit();
	}
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
bool OSThread::IsRunning()
{
	return (m_threadID >= 0);
}

///////////////////////////////////////////////////////////////////////////////
// If this is set, the thread should die!
///////////////////////////////////////////////////////////////////////////////
bool OSThread::TimeToDie()
{
	return m_dieNow;
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
bool OSThread::SignalDeath()
{
	if (m_threadID < 0)
		return false;

	m_dieNow = true;
	return true;
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
void OSThread::Sleep(unsigned int milliseconds)
{
	// Sony call takes microseconds
	DelayThread(milliseconds * 1000);
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
void OSThread::ThreadEntry(OSThread *me)
{
	// Run!
	me->Startup();
	while (!me->TimeToDie())
	{
		if (!me->Run())
			break;
	}
	me->Cleanup();

	// Shut us down
	me->m_threadID = -1;
	ExitDeleteThread();
}


