///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
OSThread::OSThread()
{
	m_thread = 0;
	m_dieNow = false;
}

///////////////////////////////////////////////////////////////////////////////
// Don't delete unless you KIll(true)
///////////////////////////////////////////////////////////////////////////////
OSThread::~OSThread()
{
	// Make sure they are dead
	ASSERT(m_thread == 0);
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
bool OSThread::Start(Priority priority)
{
	ASSERT(m_thread == 0);

	DWORD threadID;
	m_thread = CreateThread(NULL, 0, ThreadEntry, this, CREATE_SUSPENDED, &threadID);
	ASSERT(m_thread);
	if (!m_thread)
		return false;
	SetThreadAffinityMask(m_thread, 1<<0);
	BOOL success = SetThreadPriority(m_thread, ConvertPriority(priority));
	ASSERT(success);

	ResumeThread(m_thread);
	return true;
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
int OSThread::ConvertPriority(Priority priority) const
{
	if (priority < OSThread::VERY_LOW)
		priority = OSThread::VERY_LOW;
	else if (priority > OSThread::VERY_HIGH)
		priority = OSThread::VERY_HIGH;

	switch (priority)
	{
		case VERY_LOW:
			return THREAD_PRIORITY_LOWEST;
		case LOW:
			return THREAD_PRIORITY_BELOW_NORMAL;
		case HIGH:
			return THREAD_PRIORITY_ABOVE_NORMAL;
		case VERY_HIGH:
			return THREAD_PRIORITY_HIGHEST;
		default:
			ASSERT(0);
		case NORMAL:
			return THREAD_PRIORITY_NORMAL;
	}
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
void OSThread::WaitForExit()
{
	while (m_thread)
		::Sleep(0);
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
void OSThread::Kill(bool wait)
{
	if (m_thread)
	{
		SignalDeath();
		if (wait)
			WaitForExit();
	}
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
bool OSThread::IsRunning()
{
	return (m_thread != 0);
}

///////////////////////////////////////////////////////////////////////////////
// If this is set, the thread should die!
///////////////////////////////////////////////////////////////////////////////
bool OSThread::TimeToDie()
{
	return m_dieNow;
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
bool OSThread::SignalDeath()
{
	if (!m_thread)
		return false;

	m_dieNow = true;
	return true;
}

///////////////////////////////////////////////////////////////////////////////
// Call this to wait
///////////////////////////////////////////////////////////////////////////////
void OSThread::Sleep(
unsigned int milliseconds)
{
	::Sleep(milliseconds);
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
DWORD WINAPI OSThread::ThreadEntry(void *param)
{
	OSThread *me = (OSThread *)param;

	// Run!
	me->Startup();
	while (!me->TimeToDie())
	{
		if (!me->Run())
			break;
	}
	me->Cleanup();

	// Shut us down
	me->m_thread = 0;
	ExitThread(0);
	return 0;
}

