///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
#include "Layers/LayersPCH.h"
#include "Layers/Semaphore/Semaphore.h"

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
CSemaphore::CSemaphore(bool initialize)
{
	m_mutex = NULL;

	if (initialize)
		Initialize();
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
CSemaphore::~CSemaphore()
{
	ASSERT(m_mutex != NULL);
	CloseHandle(m_mutex);
}

///////////////////////////////////////////////////////////////////////////////
// initialize and uninited semaphore
///////////////////////////////////////////////////////////////////////////////
void CSemaphore::Initialize()
{
	ASSERTS(m_mutex == NULL, "Semaphore already initialized");

	// Create the semaphore
	m_mutex = CreateMutex(NULL, false, NULL);
	ASSERT(m_mutex != NULL);
}

///////////////////////////////////////////////////////////////////////////////
// determine if initialize still needs to be called
///////////////////////////////////////////////////////////////////////////////
bool CSemaphore::IsInitialized()
{
	return (m_mutex != NULL);
}

///////////////////////////////////////////////////////////////////////////////
// aquire the semaphore or return false if its not available.
///////////////////////////////////////////////////////////////////////////////
bool CSemaphore::Aquire()
{
	DWORD result = WaitForSingleObject(m_mutex, 0);
	ASSERT(result != WAIT_ABANDONED);

	return (result == WAIT_OBJECT_0 || result == WAIT_ABANDONED);
}

///////////////////////////////////////////////////////////////////////////////
// aquire the semaphore and block until its available
///////////////////////////////////////////////////////////////////////////////
void CSemaphore::AquireUnconditionally()
{
#ifdef _DEBUG
	// See how often we block
	DWORD debugResult = WaitForSingleObject(m_mutex, 0);
	if (debugResult == WAIT_OBJECT_0 || debugResult == WAIT_ABANDONED)
		return;
	TRACE("Oh Shit Captain! We blocked on a semaphore!.\n");
#endif

	DWORD result = WaitForSingleObject(m_mutex, INFINITE);
	ASSERT(result != WAIT_ABANDONED);
	ASSERT(result == WAIT_OBJECT_0 || result == WAIT_ABANDONED);
}

///////////////////////////////////////////////////////////////////////////////
// release the semaphore.
///////////////////////////////////////////////////////////////////////////////
void CSemaphore::Release()
{
	ASSERT(m_mutex);
	BOOL ret = ReleaseMutex(m_mutex);
	ASSERT(ret);
}
