/*************************************/
/*                                   */
/*   MathStats.h                     */
/*   new game engine  11/05/01       */
/*   ned martin  avalanche software  */
/*   visual c++ 6.0                  */
/*   frequency-of-use stats          */
/*                                   */
/*************************************/

#ifndef __M_MATHSTATS_H
#define __M_MATHSTATS_H

/******************* includes ****************************/

/* system includes */

/* engine includes */

/******************* defines *****************************/

/* uncomment this out to enable collection of stats-- each time a math routine is called, it will increment
the correct entry in the stats table */

/************** NOTE! do not leave this defined!!! ***********************/

//#define MATH_STATS
#ifdef CONSUMER_BUILD	// paranoia
#undef MATH_STATS
#endif //CONSUMER_BUILD

/* each math routine gets an index to increment a table of frequency counters. if you add to this you should
update the MathStatsName table in Math.cpp as well (you can just add an entry on to the end, though i would
encourage you to put it in the correct spot) */

enum
{
	/* Vect2.hpp */

	VECTOR2_CLEAR,
	VECTOR2_SET_F,
	VECTOR2_SET_FARRAY,
	VECTOR2_DOT_V2,
	VECTOR2_DIAG_V2,
	VECTOR2_LENGTH,
	VECTOR2_LENGTH_SQUARED,
	VECTOR2_NORMALIZE,
	VECTOR2_NORMALIZED,
	VECTOR2_PROJECTION_V2,
	VECTOR2_NEGATE,
	VECTOR2_DOT2_V2_V2,
	VECTOR2_DIAG_V2_V2,
	VECTOR2_LENGTH_V2,
	VECTOR2_NORMALIZE_V2,
	VECTOR2_EQUALS_V2,
	VECTOR2_NOT_EQUAL_V2,
	VECTOR2_PLUS_EQUALS_V2,
	VECTOR2_MINUS_EQUALS_V2,
	VECTOR2_TIMES_EQUALS_F,
	VECTOR2_DIVIDE_EQUALS_F,
	VECTOR2_PLUS_V2,
	VECTOR2_MINUS_V2,
	VECTOR2_TIMES_F,
	VECTOR2_DIVIDE_F,
	VECTOR2_ARRAY_INDEX,
	VECTOR2_CAST_F,

	/* Vect3.hpp */

	VECTOR3_CLEAR,
	VECTOR3_SET_F,
	VECTOR3_SET_FARRAY,
	VECTOR3_SET_V4,
	VECTOR3_DOT_V3,
	VECTOR3_CROSS_V3,
	VECTOR3_DIAG_V3,
	VECTOR3_PROJECTION_V3,
	VECTOR3_LENGTH,
	VECTOR3_LENGTH_XZ,
	VECTOR3_LENGTH_SQUARED,
	VECTOR3_LENGTH_XZ_SQUARED,
	VECTOR3_NORMALIZE,
	VECTOR3_NORMALIZED,
	VECTOR3_NEGATE,
	VECTOR3_NEGATED,
	VECTOR3_DOT_V3_V3,
	VECTOR3_CROSS_V3_V3,
	VECTOR3_DIAG_V3_V3,
	VECTOR3_LENGTH_V3,
	VECTOR3_LENGTHXZ_V3,
	VECTOR3_LENGTH_SQUARED_V3,
	VECTOR3_LENGTHXZ_SQUARED_V3,
	VECTOR3_NORMALIZE_V3,
	VECTOR3_PROJECTION_V3_V3,
	VECTOR3_EQUALS_V3,
	VECTOR3_NOT_EQUAL_V3,
	VECTOR3_PLUS_EQUALS_V3,
	VECTOR3_MINUS_EQUALS_V3,
	VECTOR3_TIMES_EQUALS_F,
	VECTOR3_DIVIDE_EQUALS_F,
	VECTOR3_PLUS_V3,
	VECTOR3_MINUS_V3,
	VECTOR3_TIMES_F,
	VECTOR3_DIVIDE_F,
	VECTOR3_TIMES_M3X3,
	VECTOR3_DIVIDE_D3X3,
	VECTOR3_ARRAY_INDEX,
	VECTOR3_FAST_MULTIPLY,
	VECTOR3_FAST_BASIS_TRANSFORM,
	VECTOR3_CAST_F,

	/* Vect4.hpp */

	VECTOR4_CLEAR,
	VECTOR4_SET_F,
	VECTOR4_SET_FARRAY,
	VECTOR4_SET_V3,
	VECTOR4_DOT_V4,
	VECTOR4_CROSS_V4,
	VECTOR4_DIAG_V4,
	VECTOR4_LENGTH,
	VECTOR4_LENGTH_SQUARED,
	VECTOR4_NORMALIZE,
	VECTOR4_NORMALIZED,
	VECTOR4_NEGATE,
	VECTOR4_DOT_V4_V4,
	VECTOR4_CROSS_V4_V4,
	VECTOR4_DIAG_V4_V4,
	VECTOR4_LENGTH_V4,
	VECTOR4_NORMALIZE_V4,
	VECTOR4_EQUALS_V4,
	VECTOR4_NOT_EQUAL_V4,
	VECTOR4_PLUS_EQUALS_V4,
	VECTOR4_MINUS_EQUALS_V4,
	VECTOR4_TIMES_EQUALS_F,
	VECTOR4_DIVIDE_EQUALS_F,
	VECTOR4_PLUS_V4,
	VECTOR4_MINUS_F4,
	VECTOR4_TIMES_F,
	VECTOR4_DIVIDE_F,
	VECTOR4_ARRAY_INDEX,
	VECTOR4_FAST_MULTIPLY,
	VECTOR4_FAST_TRANSFORM,
	VECTOR4_FAST_BASIS_TRANSFORM,
	VECTOR4_CAST_F,

	/* miscellaneous vector routines from Vector.hpp */

	F_TIMES_V2,
	F_TIMES_V3,
	F_TIMES_V4,
	ROTATE_POINT_AROUND_AXIS,
	NEAREST_POINT_ON_LINE_SEG_V2,
	NEAREST_POINT_ON_LINE_SEG_V3,
	NEAREST_POINT_ON_LINE_V2,
	NEAREST_POINT_ON_LINE_V3,
	DISTANCE_V3_V3,
	DISTANCE_SQUARED_V3_V3,
	POINTS_COINCIDE_V3_V3_F,

	/* Mat3x3.hpp */

	MATRIX3X3_CONSTRUCT_F,
	MATRIX3X3_CONSTRUCT_V3,
	MATRIX3X3_CONSTRUCT_G4X4,
	MATRIX3X3_ASSIGN_M3X3,
	MATRIX3X3_ASSIGN_G4X4,
	MATRIX3X3_SET_F,
	MATRIX3X3_DIAGONALIZE_V3,
	MATRIX3X3_SKEW_SYMMETRIC_V3,
	MATRIX3X3_IDENTITY,
	MATRIX3X3_IS_IDENTITY,
	MATRIX3X3_TRANSPOSE_M3X3,
	MATRIX3X3_TRANSPOSE,
	MATRIX3X3_TRANSPOSED,
	MATRIX3X3_INVERT,
	MATRIX3X3_DET_M3X3,
	MATRIX3X3_DET,
	MATRIX3X3_COF_M3X3,
	MATRIX3X3_COF,
	MATRIX3X3_ADJ_M3X3,
	MATRIX3X3_ADJ,
	MATRIX3X3_EQUALS_M3X3,
	MATRIX3X3_NOT_EQUAL_M3X3,
	MATRIX3X3_TIMES_F,
	MATRIX3X3_TIMES_EQUALS_F,
	MATRIX3X3_DIVIDE_F,
	MATRIX3X3_DIVIDE_EQUALS_F,
	MATRIX3X3_PLUS_M3X3,
	MATRIX3X3_PLUS_EQUALS_M3X3,
	MATRIX3X3_MINUS_M3X3,
	MATRIX3X3_MINUS_EQUALS_M3X3,
	MATRIX3X3_TIMES_M3X3,
	MATRIX3X3_TIMES_EQUALS_M3X3,
	MATRIX3X3_TIMES_M4X4,
	MATRIX3X3_TIMES_G4X4,
	MATRIX3X3_DIVIDE_C4X4,
	MATRIX3X3_DIVIDE_D3X3,
	MATRIX3X3_DIVIDE_EQUALS_D3X3,
	MATRIX3X3_TIMES_UL_G4X4,
	MATRIX3X3_TIMES_EQUALS_UL_G4X4,
	MATRIX3X3_ROW_I,
	MATRIX3X3_COLUMN_I,
	MATRIX3X3_SET_ROW_I_V3,
	MATRIX3X3_SET_COLUMN_I_V3,
	MATRIX3X3_GET_ROW0_V3,
	MATRIX3X3_GET_ROW1_V3,
	MATRIX3X3_GET_ROW2_V3,
	MATRIX3X3_GET_COLUMN0_V3,
	MATRIX3X3_GET_COLUMN1_V3,
	MATRIX3X3_GET_COLUMN2_V3,
	MATRIX3X3_SET_ROW0_V3,
	MATRIX3X3_SET_ROW1_V3,
	MATRIX3X3_SET_ROW2_V3,
	MATRIX3X3_SET_COLUMN0_V3,
	MATRIX3X3_SET_COLUMN1_V3,
	MATRIX3X3_SET_COLUMN2_V3,
	MATRIX3X3_SET_SCALE_F,
	MATRIX3X3_SET_XSCALE_F,
	MATRIX3X3_SET_YSCALE_F,
	MATRIX3X3_SET_ZSCALE_F,
	MATRIX3X3_SET_XROTATION_F,
	MATRIX3X3_SET_YROTATION_F,
	MATRIX3X3_SET_ZROTATION_F,
	MATRIX3X3_SET_XYZROTATION_V3,
	MATRIX3X3_CAT_SCALE_F,
	MATRIX3X3_CAT_XSCALE_F,
	MATRIX3X3_CAT_YSCALE_F,
	MATRIX3X3_CAT_ZSCALE_F,
	MATRIX3X3_CAT_XROTATION_F,
	MATRIX3X3_CAT_YROTATION_F,
	MATRIX3X3_CAT_ZROTATION_F,
	DIRCOS3X3_INVERT,
	DIRCOS3X3_INVERT_TIMES_M4X4,
	DIRCOS3X3_INVERT_TIMES_G4X4,
	DIRCOS3X3_INVERT_TIMES_M3X3,
	DIRCOS3X3_INVERT_TIMES_EQUALS_D3X3,
	DIRCOS3X3_INVERT_DIVIDE_C4X4,
	DIRCOS3X3_INVERT_DIVIDE_D3X3,
	DIRCOS3X3_INVERT_DIVIDE_EQUALS_D3X3,

	/* Mat3x3.cpp */

	MATRIX3X3_INVERT_M3X3,
	DIRCOS3X3_INVERT_D3X3,
	DIRCOS3X3_ORTHONORMALIZE,
	DIRCOS3X3_ORTHOGANALIZE,
	DIRCOS3X3_DECODE_TO_YXZ_V3,
	DIRCOS3X3_DECODE_TO_XZY_V3,
	DIRCOS3X3_DECODE_TO_ZYX_V3,
	DIRCOS3X3_BUILD_FROM_VECTOR_V3,
	MATRIX3X3_DECONSTRUCT,

	/* Mat4x4.hpp */

	MATRIX4X4_CONSTRUCT_F,
	MATRIX4X4_ASSIGN_M4X4,
	MATRIX4X4_SET_F,
	MATRIX4X4_IDENTITY,
	MATRIX4X4_IS_IDENTITY,
	MATRIX4X4_INVERT,
	MATRIX4X4_TRANSPOSE_M4X4,
	MATRIX4X4_TRANSPOSE,
	MATRIX4X4_DET_M4X4,
	MATRIX4X4_DET,
	MATRIX4X4_COF_M4X4,
	MATRIX4X4_COF,
	MATRIX4X4_ADJ_M4X4,
	MATRIX4X4_ADJ,
	MATRIX4X4_EQUALS_M4X4,
	MATRIX4X4_NOT_EQUAL_M4X4,
	MATRIX4X4_TIMES_F,
	MATRIX4X4_DIVIDE_F,
	MATRIX4X4_TIMES_EQUALS_F,
	MATRIX4X4_DIVIDE_EQUALS_F,
	MATRIX4X4_PLUS_M4X4,
	MATRIX4X4_PLUS_EQUALS_M4X4,
	MATRIX4X4_MINUS_M4X4,
	MATRIX4X4_MINUS_EQUALS_M4X4,
	MATRIX4X4_FAST_MULTIPLY,
	MATRIX4X4_TIMES_M4X4,
	MATRIX4X4_TIMES_EQUALS_M4X4,
	MATRIX4X4_TIMES_G4X4,
	MATRIX4X4_TIMES_EQUALS_G4X4,
	MATRIX4X4_DIVIDE_C4X4,
	MATRIX4X4_DIVIDE_EQUALS_C4X4,
	MATRIX4X4_TIMES_M3X3,
	MATRIX4X4_TIMES_EQUALS_M3X3,
	MATRIX4X4_DIVIDE_D3X3,
	MATRIX4X4_DIVIDE_EQUALS_D3X3,
	MATRIX4X4_ROW_I,
	MATRIX4X4_COLUMN_I,
	MATRIX4X4_SET_ROW_I_V3,
	MATRIX4X4_SET_COLUMN_I_V3,
	MATRIX4X4_GET_ROW0_V3,
	MATRIX4X4_GET_ROW1_V3,
	MATRIX4X4_GET_ROW2_V3,
	MATRIX4X4_GET_ROW3_V3,
	MATRIX4X4_GET_COLUMN0_V3,
	MATRIX4X4_GET_COLUMN1_V3,
	MATRIX4X4_GET_COLUMN2_V3,
	MATRIX4X4_GET_COLUMN3_V3,
	MATRIX4X4_SET_ROW0_V3,
	MATRIX4X4_SET_ROW1_V3,
	MATRIX4X4_SET_ROW2_V3,
	MATRIX4X4_SET_ROW3_V3,
	MATRIX4X4_SET_COLUMN0_V3,
	MATRIX4X4_SET_COLUMN1_V3,
	MATRIX4X4_SET_COLUMN2_V3,
	MATRIX4X4_SET_COLUMN3_V3,
	GRAPHICS4X4_CONSTRUCT_M3X3_V3,
	GRAPHICS4X4_CONSTRUCT_F,
	GRAPHICS4X4_ASSIGN_M3X3,
	GRAPHICS4X4_SET_M3X3,
	GRAPHICS4X4_DET_G4X4,
	GRAPHICS4X4_DET,
	GRAPHICS4X4_COF_M4X4,
	GRAPHICS4X4_ADJ_M4X4,
	GRAPHICS4X4_INVERT,
	GRAPHICS4X4_EQUALS_G4X4,
	GRAPHICS4X4_NOT_EQUAL_G4X4,
	GRAPHICS4X4_FAST_MULTIPLY,
	GRAPHICS4X4_TIMES_M4X4,
	GRAPHICS4X4_TIMES_G4X4,
	GRAPHICS4X4_TIMES_EQUALS_G4X4,
	GRAPHICS4X4_DIVIDE_C4X4,
	GRAPHICS4X4_DIVIDE_EQUALS_C4X4,
	GRAPHICS4X4_TRANSFORM_F,
	GRAPHICS4X4_SET_SCALE_F,
	GRAPHICS4X4_SET_XSCALE_F,
	GRAPHICS4X4_SET_YSCALE_F,
	GRAPHICS4X4_SET_ZSCALE_F,
	GRAPHICS4X4_SET_XROTATION_F,
	GRAPHICS4X4_SET_YROTATION_F,
	GRAPHICS4X4_SET_ZROTATION_F,
	GRAPHICS4X4_SET_XYZROTATION_V3,
	GRAPHICS4X4_SET_XYZROTATION_DEG_V3,
	GRAPHICS4X4_SET_TRANSLATION_F,
	GRAPHICS4X4_SET_TRANSLATION_V3,
	GRAPHICS4X4_SET_XTRANSLATION_F,
	GRAPHICS4X4_SET_YTRANSLATION_F,
	GRAPHICS4X4_SET_ZTRANSLATION_F,
	GRAPHICS4X4_POKE_TRANSLATION_F,
	GRAPHICS4X4_POKE_TRANSLATION_V3,
	GRAPHICS4X4_POKE_XTRANSLATION_F,
	GRAPHICS4X4_POKE_YTRANSLATION_F,
	GRAPHICS4X4_POKE_ZTRANSLATION_F,
	GRAPHICS4X4_CAT_SCALE_F,
	GRAPHICS4X4_CAT_XSCALE_F,
	GRAPHICS4X4_CAT_YSCALE_F,
	GRAPHICS4X4_CAT_ZSCALE_F,
	GRAPHICS4X4_CAT_XROTATION_F,
	GRAPHICS4X4_CAT_YROTATION_F,
	GRAPHICS4X4_CAT_ZROTATION_F,
	GRAPHICS4X4_CAT_TRANSLATION_F,
	GRAPHICS4X4_CAT_XTRANSLATION_F,
	GRAPHICS4X4_CAT_YTRANSLATION_F,
	GRAPHICS4X4_CAT_ZTRANSLATION_F,
	GRAPHICS4X4_REVERSE_CAT_SCALE_F,
	GRAPHICS4X4_REVERSE_CAT_XSCALE_F,
	GRAPHICS4X4_REVERSE_CAT_YSCALE_F,
	GRAPHICS4X4_REVERSE_CAT_ZSCALE_F,
	GRAPHICS4X4_REVERSE_CAT_XROTATION_F,
	GRAPHICS4X4_REVERSE_CAT_YROTATION_F,
	GRAPHICS4X4_REVERSE_CAT_ZROTATION_F,
	GRAPHICS4X4_REVERSE_CAT_TRANSLATION_F,
	GRAPHICS4X4_REVERSE_CAT_XTRANSLATION_F,
	GRAPHICS4X4_REVERSE_CAT_YTRANSLATION_F,
	GRAPHICS4X4_REVERSE_CAT_ZTRANSLATION_F,
	GRAPHICS4X4_GET_ORIENTATION_M3X3,
	GRAPHICS4X4_POKE_ORIENTATION_M3X3,
	GRAPHICS4X4_COMPOSE_M3X3_V3,
	GRAPHICS4X4_DECOMPOSE_M3X3_V3,
	CARTESIAN4X4_CONSTRUCT_M3X3_V3,
	CARTESIAN4X4_INVERT,
	CARTESIAN4X4_INVERT_TIMES_M4X4,
	CARTESIAN4X4_INVERT_TIMES_G4X4,
	CARTESIAN4X4_INVERT_TIMES_EQUALS_C4X4,
	CARTESIAN4X4_INVERT_TIMES_M3X3,
	CARTESIAN4X4_INVERT_TIMES_EQUALS_D3X3,
	CARTESIAN4X4_INVERT_DIVIDE_C4X4,
	CARTESIAN4X4_INVERT_DIVIDE_EQUALS_C4X4,
	CARTESIAN4X4_INVERT_DIVIDE_D3X3,
	CARTESIAN4X4_INVERT_DIVIDE_EQUALS_D3X3,

	/* Mat4x4.cpp */

	MATRIX4X4_INVERT_M4X4,
	GRAPHICS4X4_INVERT_M4X4,
	CARTESIAN4X4_INVERT_M4X4,
	GRAPHICS4X4_DECODE_TO_YXZ_V3,
	GRAPHICS4X4_DECODE_TO_XZY_V3,
	GRAPHICS4X4_DECODE_TO_ZYX_V3,
	GRAPHICS4X4_SET_INTERMEDIATE_F_G4X4,
	GRAPHICS4X4_BUILD_FROM_QUAT_F,
	GRAPHICS4X4_BUILD_FROM_VECTOR_V3,
	MATRIX4X4_DECONSTRUCT,
	GRAPHICS4X4_DECONSTRUCT,
	GRAPHICS4X4_TRANSFORM_ARRAY_V3_V3_I,
	GRAPHICS4X4_TRANSFORM_ARRAY_V4_V4_I,
	GRAPHICS4X4_BASIS_TRANSFORM_ARRAY_V3_V3_I,
	GRAPHICS4X4_BASIS_TRANSFORM_ARRAY_V4_V4_I,

	/* miscellaneous matrix routines from Matrix.hpp */

	F_TIMES_MATRIX3X3,
	F_TIMES_MATRIX4X4,

	/*** must be last!!! ***/

	MATH_STATS_COUNT
};

/******************* macros ******************************/

#ifdef MATH_STATS
#define MATH_STATS_INC(nIndex)	{ ASSERT((unsigned) nIndex < MATH_STATS_COUNT); nMathStats[nIndex]++; }
#endif //MATH_STATS

/******************* structures **************************/

/******************* global variables ********************/

#ifdef MATH_STATS
extern int nMathStats[];
#endif //MATH_STATS

/******************* global prototypes *******************/

#ifdef MATH_STATS
void MathStats__Clear(void);
void MathStats__Report(void);
#endif //MATH_STATS



#endif // __M_MATHSTATS_H


