
///////////////////////////////////////////////////////////////////////////////
// real number in [0,1]
///////////////////////////////////////////////////////////////////////////////
inline float MTwister::Rand()
{
	return (float)(RandInt() >> 8) * (1.0f / 16777216.0f);
}

///////////////////////////////////////////////////////////////////////////////
// real number in [0,n]
///////////////////////////////////////////////////////////////////////////////
inline float MTwister::Rand(float n)
{
	return Rand() * n;
}

///////////////////////////////////////////////////////////////////////////////
// real number in [0,1)
///////////////////////////////////////////////////////////////////////////////
inline float MTwister::RandExcludeHigh()
{
	return (float)(RandInt() >> 8) * (1.0f / 16777217.0f);
}

///////////////////////////////////////////////////////////////////////////////
// real number in [0,n)
///////////////////////////////////////////////////////////////////////////////
inline float MTwister::RandExcludeHigh(float n)
{
	return RandExcludeHigh() * n;
}

///////////////////////////////////////////////////////////////////////////////
// real number in (0,1)
///////////////////////////////////////////////////////////////////////////////
inline float MTwister::RandExcludeLowHigh()
{
	return ((float)(RandInt() >> 8) + 0.5f) * (1.0f / 16777217.0f);
}

///////////////////////////////////////////////////////////////////////////////
// real number in (0,n)
///////////////////////////////////////////////////////////////////////////////
inline float MTwister::RandExludeLowHigh(float n)
{
	return RandExcludeLowHigh() * n;
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
inline unsigned int MTwister::RandInt()
{
	// Pull a 32-bit integer from the generator state
	// Every other access function simply transforms the numbers extracted here
	if (m_left == 0)
		Reload();
	--m_left;

	register unsigned int s1 = *m_next++;
	s1 ^= (s1 >> 11);
	s1 ^= (s1 <<  7) & 0x9d2c5680UL;
	s1 ^= (s1 << 15) & 0xefc60000UL;
	return (s1 ^ (s1 >> 18));
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
inline unsigned int MTwister::RandInt(
unsigned int n)
{
	// Find which bits are used in n
	// Optimized by Magnus Jonsson (magnus@smartelectronix.com)
	unsigned int used = n;
	used |= used >> 1;
	used |= used >> 2;
	used |= used >> 4;
	used |= used >> 8;
	used |= used >> 16;

	// Draw numbers until one is found in [0,n]
	unsigned int i;
	do
	{
		i = RandInt() & used;  // toss unused bits to shorten search
	}
	while( i > n );

	return i;
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
inline int MTwister::RandSignedInt()
{
	return (int)(RandInt() >> 1);
}

///////////////////////////////////////////////////////////////////////////////
// integer in [0,n] for n < MaxInt
///////////////////////////////////////////////////////////////////////////////
inline int MTwister::RandSignedInt(int n)
{
	return (RandSignedInt() % (n + 1));
}


