/*******************************************************************\
*																	*
*  EAXLEGACY.H - For use with EAX Version 4.0						*
*																	*
*  File revision 0.1 (21 Febtruary 2003)							*
*																	*
*  This header file redefines all EAX 3.0 legacy properties,		*
*  parameters and structure names to their EAX 4.0 counterparts.	*
*  The header file also includes redefinitions of the preset and	*
*  structure names used in the definition of new reverb presets		*
*  in the eax-util.h file.											*
*																	*
*  Applications supporting EAX 3.0 can be recompiled using this 	*
*  header file to update their application to use EAX 4.0 without	*
*  code changes.  													*
*																	*
*  This header is NOT recommended for applications that are not		*
*  being upgraded from EAX 3.0.										*
*																	*
\*******************************************************************/

////////////////////////////////////////////////////////////////////////////
// EAX Legacy Definitions.

// Legacy listener object definition.
#define DSPROPSETID_EAX_ListenerProperties EAXPROPERTYID_EAX40_FXSlot0

// Legacy buffer/source object definitions.
#define DSPROPSETID_EAX_BufferProperties EAXPROPERTYID_EAX40_Source
#define DSPROPSETID_EAX_SourceProperties EAXPROPERTYID_EAX40_Source

// Legacy EAX listener property definitions.
#define DSPROPERTY_EAX_LISTENERPROPERTY              EAXREVERB_PROPERTY
#define DSPROPERTY_EAXLISTENER_NONE                  EAXREVERB_NONE
#define DSPROPERTY_EAXLISTENER_ALLPARAMETERS         EAXREVERB_ALLPARAMETERS
#define DSPROPERTY_EAXLISTENER_ENVIRONMENT           EAXREVERB_ENVIRONMENT
#define DSPROPERTY_EAXLISTENER_ENVIRONMENTSIZE       EAXREVERB_ENVIRONMENTSIZE
#define DSPROPERTY_EAXLISTENER_ENVIRONMENTDIFFUSION  EAXREVERB_ENVIRONMENTDIFFUSION
#define DSPROPERTY_EAXLISTENER_ROOM                  EAXREVERB_ROOM
#define DSPROPERTY_EAXLISTENER_ROOMHF                EAXREVERB_ROOMHF
#define DSPROPERTY_EAXLISTENER_ROOMLF                EAXREVERB_ROOMLF
#define DSPROPERTY_EAXLISTENER_DECAYTIME             EAXREVERB_DECAYTIME
#define DSPROPERTY_EAXLISTENER_DECAYHFRATIO          EAXREVERB_DECAYHFRATIO
#define DSPROPERTY_EAXLISTENER_DECAYLFRATIO          EAXREVERB_DECAYLFRATIO
#define DSPROPERTY_EAXLISTENER_REFLECTIONS           EAXREVERB_REFLECTIONS
#define DSPROPERTY_EAXLISTENER_REFLECTIONSDELAY      EAXREVERB_REFLECTIONSDELAY
#define DSPROPERTY_EAXLISTENER_REFLECTIONSPAN        EAXREVERB_REFLECTIONSPAN
#define DSPROPERTY_EAXLISTENER_REVERB                EAXREVERB_REVERB
#define DSPROPERTY_EAXLISTENER_REVERBDELAY           EAXREVERB_REVERBDELAY
#define DSPROPERTY_EAXLISTENER_REVERBPAN             EAXREVERB_REVERBPAN
#define DSPROPERTY_EAXLISTENER_ECHOTIME              EAXREVERB_ECHOTIME
#define DSPROPERTY_EAXLISTENER_ECHODEPTH             EAXREVERB_ECHODEPTH
#define DSPROPERTY_EAXLISTENER_MODULATIONTIME        EAXREVERB_MODULATIONTIME
#define DSPROPERTY_EAXLISTENER_MODULATIONDEPTH       EAXREVERB_MODULATIONDEPTH
#define DSPROPERTY_EAXLISTENER_AIRABSORPTIONHF       EAXREVERB_AIRABSORPTIONHF
#define DSPROPERTY_EAXLISTENER_HFREFERENCE           EAXREVERB_HFREFERENCE
#define DSPROPERTY_EAXLISTENER_LFREFERENCE           EAXREVERB_LFREFERENCE
#define DSPROPERTY_EAXLISTENER_ROOMROLLOFFFACTOR     EAXREVERB_ROOMROLLOFFFACTOR
#define DSPROPERTY_EAXLISTENER_FLAGS                 EAXREVERB_FLAGS

// Legacy EAX listener flag definitions.
#define DSPROPERTY_EAXLISTENER_IMMEDIATE               EAXREVERB_IMMEDIATE
#define DSPROPERTY_EAXLISTENER_DEFERRED                EAXREVERB_DEFERRED
#define DSPROPERTY_EAXLISTENER_COMMITDEFERREDSETTINGS  EAXREVERB_COMMITDEFERREDSETTINGS
#define EAXLISTENERFLAGS_DECAYTIMESCALE                EAXREVERBFLAGS_DECAYTIMESCALE 
#define EAXLISTENERFLAGS_REFLECTIONSSCALE              EAXREVERBFLAGS_REFLECTIONSSCALE
#define EAXLISTENERFLAGS_REFLECTIONSDELAYSCALE         EAXREVERBFLAGS_REFLECTIONSDELAYSCALE
#define EAXLISTENERFLAGS_REVERBSCALE                   EAXREVERBFLAGS_REVERBSCALE
#define EAXLISTENERFLAGS_REVERBDELAYSCALE              EAXREVERBFLAGS_REVERBDELAYSCALE
#define EAXLISTENERFLAGS_DECAYHFLIMIT                  EAXREVERBFLAGS_DECAYHFLIMIT
#define EAXLISTENERFLAGS_ECHOTIMESCALE                 EAXREVERBFLAGS_ECHOTIMESCALE
#define EAXLISTENERFLAGS_MODULATIONTIMESCALE           EAXREVERBFLAGS_MODULATIONTIMESCALE
#define EAXLISTENERFLAGS_RESERVED                      EAXREVERBFLAGS_RESERVED

// Legacy EAX listener structure definitions.
#define EAXLISTENERPROPERTIES   EAXREVERBPROPERTIES
#define LPEAXLISTENERPROPERTIES LPEAXREVERBPROPERTIES

// Legacy EAX listener property ranges and defaults:
#define EAXLISTENER_MINENVIRONMENT                EAXREVERB_MINENVIRONMENT
#define EAXLISTENER_MAXENVIRONMENT                EAXREVERB_MAXENVIRONMENT
#define EAXLISTENER_DEFAULTENVIRONMENT            EAXREVERB_DEFAULTENVIRONMENT

#define EAXLISTENER_MINENVIRONMENTSIZE            EAXREVERB_MINENVIRONMENTSIZE
#define EAXLISTENER_MAXENVIRONMENTSIZE            EAXREVERB_MAXENVIRONMENTSIZE
#define EAXLISTENER_DEFAULTENVIRONMENTSIZE        EAXREVERB_DEFAULTENVIRONMENTSIZE

#define EAXLISTENER_MINENVIRONMENTDIFFUSION       EAXREVERB_MINENVIRONMENTDIFFUSION
#define EAXLISTENER_MAXENVIRONMENTDIFFUSION       EAXREVERB_MAXENVIRONMENTDIFFUSION
#define EAXLISTENER_DEFAULTENVIRONMENTDIFFUSION   EAXREVERB_DEFAULTENVIRONMENTDIFFUSION

#define EAXLISTENER_MINROOM                       EAXREVERB_MINROOM
#define EAXLISTENER_MAXROOM                       EAXREVERB_MAXROOM
#define EAXLISTENER_DEFAULTROOM                   EAXREVERB_DEFAULTROOM 

#define EAXLISTENER_MINROOMHF                     EAXREVERB_MINROOMHF
#define EAXLISTENER_MAXROOMHF                     EAXREVERB_MAXROOMHF
#define EAXLISTENER_DEFAULTROOMHF                 EAXREVERB_DEFAULTROOMHF

#define EAXLISTENER_MINROOMLF                     EAXREVERB_MINROOMLF
#define EAXLISTENER_MAXROOMLF                     EAXREVERB_MAXROOMLF
#define EAXLISTENER_DEFAULTROOMLF                 EAXREVERB_DEFAULTROOMLF

#define EAXLISTENER_MINDECAYTIME                  EAXREVERB_MINDECAYTIME
#define EAXLISTENER_MAXDECAYTIME                  EAXREVERB_MAXDECAYTIME
#define EAXLISTENER_DEFAULTDECAYTIME              EAXREVERB_DEFAULTDECAYTIME

#define EAXLISTENER_MINDECAYHFRATIO               EAXREVERB_MINDECAYHFRATIO
#define EAXLISTENER_MAXDECAYHFRATIO               EAXREVERB_MAXDECAYHFRATIO
#define EAXLISTENER_DEFAULTDECAYHFRATIO           EAXREVERB_DEFAULTDECAYHFRATIO

#define EAXLISTENER_MINDECAYLFRATIO               EAXREVERB_MINDECAYLFRATIO
#define EAXLISTENER_MAXDECAYLFRATIO               EAXREVERB_MAXDECAYLFRATIO
#define EAXLISTENER_DEFAULTDECAYLFRATIO           EAXREVERB_DEFAULTDECAYLFRATIO 

#define EAXLISTENER_MINREFLECTIONS                EAXREVERB_MINREFLECTIONS
#define EAXLISTENER_MAXREFLECTIONS                EAXREVERB_MAXREFLECTIONS
#define EAXLISTENER_DEFAULTREFLECTIONS            EAXREVERB_DEFAULTREFLECTIONS

#define EAXLISTENER_MINREFLECTIONSDELAY           EAXREVERB_MINREFLECTIONSDELAY
#define EAXLISTENER_MAXREFLECTIONSDELAY           EAXREVERB_MAXREFLECTIONSDELAY
#define EAXLISTENER_DEFAULTREFLECTIONSDELAY       EAXREVERB_DEFAULTREFLECTIONSDELAY

#define EAXLISTENER_MINREVERB                     EAXREVERB_MINREVERB
#define EAXLISTENER_MAXREVERB                     EAXREVERB_MAXREVERB
#define EAXLISTENER_DEFAULTREVERB                 EAXREVERB_DEFAULTREVERB

#define EAXLISTENER_MINREVERBDELAY                EAXREVERB_MINREVERBDELAY
#define EAXLISTENER_MAXREVERBDELAY                EAXREVERB_MAXREVERBDELAY
#define EAXLISTENER_DEFAULTREVERBDELAY            EAXREVERB_DEFAULTREVERBDELAY

#define EAXLISTENER_MINECHOTIME                   EAXREVERB_MINECHOTIME
#define EAXLISTENER_MAXECHOTIME                   EAXREVERB_MAXECHOTIME    
#define EAXLISTENER_DEFAULTECHOTIME               EAXREVERB_DEFAULTECHOTIME

#define EAXLISTENER_MINECHODEPTH                  EAXREVERB_MINECHODEPTH
#define EAXLISTENER_MAXECHODEPTH                  EAXREVERB_MAXECHODEPTH
#define EAXLISTENER_DEFAULTECHODEPTH              EAXREVERB_DEFAULTECHODEPTH

#define EAXLISTENER_MINMODULATIONTIME             EAXREVERB_MINMODULATIONTIME
#define EAXLISTENER_MAXMODULATIONTIME             EAXREVERB_MAXMODULATIONTIME
#define EAXLISTENER_DEFAULTMODULATIONTIME         EAXREVERB_DEFAULTMODULATIONTIME

#define EAXLISTENER_MINMODULATIONDEPTH            EAXREVERB_MINMODULATIONDEPTH
#define EAXLISTENER_MAXMODULATIONDEPTH            EAXREVERB_MAXMODULATIONDEPTH
#define EAXLISTENER_DEFAULTMODULATIONDEPTH        EAXREVERB_DEFAULTMODULATIONDEPTH

#define EAXLISTENER_MINAIRABSORPTIONHF            EAXREVERB_MINAIRABSORPTIONHF
#define EAXLISTENER_MAXAIRABSORPTIONHF            EAXREVERB_MAXAIRABSORPTIONHF
#define EAXLISTENER_DEFAULTAIRABSORPTIONHF        EAXREVERB_DEFAULTAIRABSORPTIONHF

#define EAXLISTENER_MINHFREFERENCE                EAXREVERB_MINHFREFERENCE
#define EAXLISTENER_MAXHFREFERENCE                EAXREVERB_MAXHFREFERENCE
#define EAXLISTENER_DEFAULTHFREFERENCE            EAXREVERB_DEFAULTHFREFERENCE

#define EAXLISTENER_MINLFREFERENCE                EAXREVERB_MINLFREFERENCE
#define EAXLISTENER_MAXLFREFERENCE                EAXREVERB_MAXLFREFERENCE
#define EAXLISTENER_DEFAULTLFREFERENCE            EAXREVERB_DEFAULTLFREFERENCE

#define EAXLISTENER_MINROOMROLLOFFFACTOR          EAXREVERB_MINROOMROLLOFFFACTOR
#define EAXLISTENER_MAXROOMROLLOFFFACTOR          EAXREVERB_MAXROOMROLLOFFFACTOR
#define EAXLISTENER_DEFAULTROOMROLLOFFFACTOR      EAXREVERB_DEFAULTROOMROLLOFFFACTOR

#define EAXLISTENER_DEFAULTFLAGS                  EAXREVERB_DEFAULTFLAGS

// Legacy EAX buffer property definitions.
#define DSPROPERTY_EAX_BUFFERPROPERTY                EAXSOURCE_PROPERTY
#define DSPROPERTY_EAXBUFFER_NONE                    EAXSOURCE_NONE
#define DSPROPERTY_EAXBUFFER_ALLPARAMETERS           EAXSOURCE_ALLPARAMETERS
#define DSPROPERTY_EAXBUFFER_OBSTRUCTIONPARAMETERS   EAXSOURCE_OBSTRUCTIONPARAMETERS
#define DSPROPERTY_EAXBUFFER_OCCLUSIONPARAMETERS     EAXSOURCE_OCCLUSIONPARAMETERS
#define DSPROPERTY_EAXBUFFER_EXCLUSIONPARAMETERS     EAXSOURCE_EXCLUSIONPARAMETERS
#define DSPROPERTY_EAXBUFFER_DIRECT                  EAXSOURCE_DIRECT
#define DSPROPERTY_EAXBUFFER_DIRECTHF                EAXSOURCE_DIRECTHF
#define DSPROPERTY_EAXBUFFER_ROOM                    EAXSOURCE_ROOM
#define DSPROPERTY_EAXBUFFER_ROOMHF                  EAXSOURCE_ROOMHF
#define DSPROPERTY_EAXBUFFER_OBSTRUCTION             EAXSOURCE_OBSTRUCTION
#define DSPROPERTY_EAXBUFFER_OBSTRUCTIONLFRATIO      EAXSOURCE_OBSTRUCTIONLFRATIO
#define DSPROPERTY_EAXBUFFER_OCCLUSION               EAXSOURCE_OCCLUSION
#define DSPROPERTY_EAXBUFFER_OCCLUSIONLFRATIO        EAXSOURCE_OCCLUSIONLFRATIO
#define DSPROPERTY_EAXBUFFER_OCCLUSIONROOMRATIO      EAXSOURCE_OCCLUSIONROOMRATIO
#define DSPROPERTY_EAXBUFFER_OCCLUSIONDIRECTRATIO    EAXSOURCE_OCCLUSIONDIRECTRATIO
#define DSPROPERTY_EAXBUFFER_EXCLUSION               EAXSOURCE_EXCLUSION
#define DSPROPERTY_EAXBUFFER_EXCLUSIONLFRATIO        EAXSOURCE_EXCLUSIONLFRATIO
#define DSPROPERTY_EAXBUFFER_OUTSIDEVOLUMEHF         EAXSOURCE_OUTSIDEVOLUMEHF
#define DSPROPERTY_EAXBUFFER_DOPPLERFACTOR           EAXSOURCE_DOPPLERFACTOR
#define DSPROPERTY_EAXBUFFER_ROLLOFFFACTOR           EAXSOURCE_ROLLOFFFACTOR
#define DSPROPERTY_EAXBUFFER_ROOMROLLOFFFACTOR       EAXSOURCE_ROOMROLLOFFFACTOR
#define DSPROPERTY_EAXBUFFER_AIRABSORPTIONFACTOR     EAXSOURCE_AIRABSORPTIONFACTOR
#define DSPROPERTY_EAXBUFFER_FLAGS                   EAXSOURCE_FLAGS

// Legacy EAX buffer flag definitions.
#define DSPROPERTY_EAXBUFFER_IMMEDIATE                EAXSOURCE_PARAMETER_IMMEDIATE
#define DSPROPERTY_EAXBUFFER_DEFERRED                 EAXSOURCE_PARAMETER_DEFERRED
#define DSPROPERTY_EAXBUFFER_COMMITDEFERREDSETTINGS   EAXSOURCE_PARAMETER_COMMITDEFERREDSETTINGS
#define EAXBUFFERFLAGS_DIRECTHFAUTO                   EAXSOURCEFLAGS_DIRECTHFAUTO
#define EAXBUFFERFLAGS_ROOMAUTO                       EAXSOURCEFLAGS_ROOMAUTO
#define EAXBUFFERFLAGS_ROOMHFAUTO                     EAXSOURCEFLAGS_ROOMHFAUTO 
#define EAXBUFFERFLAGS_RESERVED                       EAXSOURCEFLAGS_RESERVED

// Legacy EAX buffer structure definitions.
#define EAXBUFFERPROPERTIES                           EAXSOURCEPROPERTIES
#define LPEAXBUFFERPROPERTIES                         LPEAXSOURCEPROPERTIES

// Legace EAX buffer property ranges and defaults definitions.
#define EAXBUFFER_MINDIRECT                     EAXSOURCE_MINDIRECT
#define EAXBUFFER_MAXDIRECT                     EAXSOURCE_MAXDIRECT
#define EAXBUFFER_DEFAULTDIRECT                 EAXSOURCE_DEFAULTDIRECT

#define EAXBUFFER_MINDIRECTHF                   EAXSOURCE_MINDIRECTHF
#define EAXBUFFER_MAXDIRECTHF                   EAXSOURCE_MAXDIRECTHF
#define EAXBUFFER_DEFAULTDIRECTHF               EAXSOURCE_DEFAULTDIRECTHF

#define EAXBUFFER_MINROOM                       EAXSOURCE_MINROOM
#define EAXBUFFER_MAXROOM                       EAXSOURCE_MAXROOM
#define EAXBUFFER_DEFAULTROOM                   EAXSOURCE_DEFAULTROOM
 
#define EAXBUFFER_MINROOMHF                     EAXSOURCE_MINROOMHF
#define EAXBUFFER_MAXROOMHF                     EAXSOURCE_MAXROOMHF
#define EAXBUFFER_DEFAULTROOMHF                 EAXSOURCE_DEFAULTROOMHF

#define EAXBUFFER_MINOBSTRUCTION                EAXSOURCE_MINOBSTRUCTION
#define EAXBUFFER_MAXOBSTRUCTION                EAXSOURCE_MAXOBSTRUCTION
#define EAXBUFFER_DEFAULTOBSTRUCTION            EAXSOURCE_DEFAULTOBSTRUCTION

#define EAXBUFFER_MINOBSTRUCTIONLFRATIO         EAXSOURCE_MINOBSTRUCTIONLFRATIO
#define EAXBUFFER_MAXOBSTRUCTIONLFRATIO         EAXSOURCE_MAXOBSTRUCTIONLFRATIO
#define EAXBUFFER_DEFAULTOBSTRUCTIONLFRATIO     EAXSOURCE_DEFAULTOBSTRUCTIONLFRATIO

#define EAXBUFFER_MINOCCLUSION                  EAXSOURCE_MINOCCLUSION
#define EAXBUFFER_MAXOCCLUSION                  EAXSOURCE_MAXOCCLUSION
#define EAXBUFFER_DEFAULTOCCLUSION              EAXSOURCE_DEFAULTOCCLUSION

#define EAXBUFFER_MINOCCLUSIONLFRATIO           EAXSOURCE_MINOCCLUSIONLFRATIO
#define EAXBUFFER_MAXOCCLUSIONLFRATIO           EAXSOURCE_MAXOCCLUSIONLFRATIO
#define EAXBUFFER_DEFAULTOCCLUSIONLFRATIO       EAXSOURCE_DEFAULTOCCLUSIONLFRATIO

#define EAXBUFFER_MINOCCLUSIONROOMRATIO         EAXSOURCE_MINOCCLUSIONROOMRATIO
#define EAXBUFFER_MAXOCCLUSIONROOMRATIO         EAXSOURCE_MAXOCCLUSIONROOMRATIO
#define EAXBUFFER_DEFAULTOCCLUSIONROOMRATIO     EAXSOURCE_DEFAULTOCCLUSIONROOMRATIO

#define EAXBUFFER_MINOCCLUSIONDIRECTRATIO       EAXSOURCE_MINOCCLUSIONDIRECTRATIO
#define EAXBUFFER_MAXOCCLUSIONDIRECTRATIO       EAXSOURCE_MAXOCCLUSIONDIRECTRATIO
#define EAXBUFFER_DEFAULTOCCLUSIONDIRECTRATIO   EAXSOURCE_DEFAULTOCCLUSIONDIRECTRATIO

#define EAXBUFFER_MINEXCLUSION                  EAXSOURCE_MINEXCLUSION
#define EAXBUFFER_MAXEXCLUSION                  EAXSOURCE_MAXEXCLUSION
#define EAXBUFFER_DEFAULTEXCLUSION              EAXSOURCE_DEFAULTEXCLUSION

#define EAXBUFFER_MINEXCLUSIONLFRATIO           EAXSOURCE_MINEXCLUSIONLFRATIO
#define EAXBUFFER_MAXEXCLUSIONLFRATIO           EAXSOURCE_MAXEXCLUSIONLFRATIO
#define EAXBUFFER_DEFAULTEXCLUSIONLFRATIO       EAXSOURCE_DEFAULTEXCLUSIONLFRATIO

#define EAXBUFFER_MINOUTSIDEVOLUMEHF            EAXSOURCE_MINOUTSIDEVOLUMEHF
#define EAXBUFFER_MAXOUTSIDEVOLUMEHF            EAXSOURCE_MAXOUTSIDEVOLUMEHF
#define EAXBUFFER_DEFAULTOUTSIDEVOLUMEHF        EAXSOURCE_DEFAULTOUTSIDEVOLUMEHF

#define EAXBUFFER_MINDOPPLERFACTOR              EAXSOURCE_MINDOPPLERFACTOR
#define EAXBUFFER_MAXDOPPLERFACTOR              EAXSOURCE_MAXDOPPLERFACTOR
#define EAXBUFFER_DEFAULTDOPPLERFACTOR          EAXSOURCE_DEFAULTDOPPLERFACTOR 

#define EAXBUFFER_MINROLLOFFFACTOR              EAXSOURCE_MINROLLOFFFACTOR
#define EAXBUFFER_MAXROLLOFFFACTOR              EAXSOURCE_MAXROLLOFFFACTOR
#define EAXBUFFER_DEFAULTROLLOFFFACTOR          EAXSOURCE_DEFAULTROLLOFFFACTOR

#define EAXBUFFER_MINROOMROLLOFFFACTOR          EAXSOURCE_MINROOMROLLOFFFACTOR
#define EAXBUFFER_MAXROOMROLLOFFFACTOR          EAXSOURCE_MAXROOMROLLOFFFACTOR
#define EAXBUFFER_DEFAULTROOMROLLOFFFACTOR      EAXSOURCE_DEFAULTROOMROLLOFFFACTOR

#define EAXBUFFER_MINAIRABSORPTIONFACTOR        EAXSOURCE_MINAIRABSORPTIONFACTOR
#define EAXBUFFER_MAXAIRABSORPTIONFACTOR        EAXSOURCE_MAXAIRABSORPTIONFACTOR
#define EAXBUFFER_DEFAULTAIRABSORPTIONFACTOR    EAXSOURCE_DEFAULTAIRABSORPTIONFACTOR 

#define EAXBUFFER_DEFAULTFLAGS                  EAXSOURCE_DEFAULTFLAGS
////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////
// EAX-UTIL Legacy Definitions.

// Legacy EAX Reverb Interpolation function (for reverb morphing)
#define EAX3ListenerInterpolate ReverbInterpolate

// Legacy Reverb presets
#define EAX30_PRESET_GENERIC REVERB_PRESET_GENERIC
#define EAX30_PRESET_PADDEDCELL REVERB_PRESET_PADDEDCELL
#define EAX30_PRESET_ROOM REVERB_PRESET_ROOM
#define EAX30_PRESET_BATHROOM REVERB_PRESET_BATHROOM
#define EAX30_PRESET_LIVINGROOM REVERB_PRESET_LIVINGROOM
#define EAX30_PRESET_STONEROOM REVERB_PRESET_STONEROOM
#define EAX30_PRESET_AUDITORIUM REVERB_PRESET_AUDITORIUM
#define EAX30_PRESET_CONCERTHALL REVERB_PRESET_CONCERTHALL
#define EAX30_PRESET_CAVE REVERB_PRESET_CAVE
#define EAX30_PRESET_ARENA REVERB_PRESET_ARENA
#define EAX30_PRESET_HANGAR REVERB_PRESET_HANGAR
#define EAX30_PRESET_CARPETTEDHALLWAY REVERB_PRESET_CARPETTEDHALLWAY
#define EAX30_PRESET_HALLWAY REVERB_PRESET_HALLWAY
#define EAX30_PRESET_STONECORRIDOR REVERB_PRESET_STONECORRIDOR
#define EAX30_PRESET_ALLEY REVERB_PRESET_ALLEY
#define EAX30_PRESET_FOREST REVERB_PRESET_FOREST
#define EAX30_PRESET_CITY REVERB_PRESET_CITY
#define EAX30_PRESET_MOUNTAINS REVERB_PRESET_MOUNTAINS
#define EAX30_PRESET_QUARRY REVERB_PRESET_QUARRY
#define EAX30_PRESET_PLAIN REVERB_PRESET_PLAIN
#define EAX30_PRESET_PARKINGLOT REVERB_PRESET_PARKINGLOT
#define EAX30_PRESET_SEWERPIPE REVERB_PRESET_SEWERPIPE
#define EAX30_PRESET_UNDERWATER REVERB_PRESET_UNDERWATER
#define EAX30_PRESET_DRUGGED REVERB_PRESET_DRUGGED
#define EAX30_PRESET_DIZZY REVERB_PRESET_DIZZY
#define EAX30_PRESET_PSYCHOTIC REVERB_PRESET_PSYCHOTIC

#define EAX30_PRESET_CASTLE_SMALLROOM REVERB_PRESET_CASTLE_SMALLROOM
#define EAX30_PRESET_CASTLE_SHORTPASSAGE REVERB_PRESET_CASTLE_SHORTPASSAGE
#define EAX30_PRESET_CASTLE_MEDIUMROOM REVERB_PRESET_CASTLE_MEDIUMROOM
#define EAX30_PRESET_CASTLE_LONGPASSAGE REVERB_PRESET_CASTLE_LONGPASSAGE
#define EAX30_PRESET_CASTLE_LARGEROOM REVERB_PRESET_CASTLE_LARGEROOM
#define EAX30_PRESET_CASTLE_HALL REVERB_PRESET_CASTLE_HALL
#define EAX30_PRESET_CASTLE_CUPBOARD REVERB_PRESET_CASTLE_CUPBOARD
#define EAX30_PRESET_CASTLE_COURTYARD REVERB_PRESET_CASTLE_COURTYARD
#define EAX30_PRESET_CASTLE_ALCOVE REVERB_PRESET_CASTLE_ALCOVE

#define EAX30_PRESET_FACTORY_ALCOVE REVERB_PRESET_FACTORY_ALCOVE
#define EAX30_PRESET_FACTORY_SHORTPASSAGE REVERB_PRESET_FACTORY_SHORTPASSAGE
#define EAX30_PRESET_FACTORY_MEDIUMROOM REVERB_PRESET_FACTORY_MEDIUMROOM
#define EAX30_PRESET_FACTORY_LONGPASSAGE REVERB_PRESET_FACTORY_LONGPASSAGE
#define EAX30_PRESET_FACTORY_LARGEROOM REVERB_PRESET_FACTORY_LARGEROOM
#define EAX30_PRESET_FACTORY_HALL REVERB_PRESET_FACTORY_HALL
#define EAX30_PRESET_FACTORY_CUPBOARD REVERB_PRESET_FACTORY_CUPBOARD
#define EAX30_PRESET_FACTORY_COURTYARD REVERB_PRESET_FACTORY_COURTYARD
#define EAX30_PRESET_FACTORY_SMALLROOM REVERB_PRESET_FACTORY_SMALLROOM

#define EAX30_PRESET_ICEPALACE_ALCOVE REVERB_PRESET_ICEPALACE_ALCOVE
#define EAX30_PRESET_ICEPALACE_SHORTPASSAGE REVERB_PRESET_ICEPALACE_SHORTPASSAGE
#define EAX30_PRESET_ICEPALACE_MEDIUMROOM REVERB_PRESET_ICEPALACE_MEDIUMROOM
#define EAX30_PRESET_ICEPALACE_LONGPASSAGE REVERB_PRESET_ICEPALACE_LONGPASSAGE
#define EAX30_PRESET_ICEPALACE_LARGEROOM REVERB_PRESET_ICEPALACE_LARGEROOM
#define EAX30_PRESET_ICEPALACE_HALL REVERB_PRESET_ICEPALACE_HALL
#define EAX30_PRESET_ICEPALACE_CUPBOARD REVERB_PRESET_ICEPALACE_CUPBOARD
#define EAX30_PRESET_ICEPALACE_COURTYARD REVERB_PRESET_ICEPALACE_COURTYARD
#define EAX30_PRESET_ICEPALACE_SMALLROOM REVERB_PRESET_ICEPALACE_SMALLROOM

#define EAX30_PRESET_SPACESTATION_ALCOVE REVERB_PRESET_SPACESTATION_ALCOVE
#define EAX30_PRESET_SPACESTATION_MEDIUMROOM REVERB_PRESET_SPACESTATION_MEDIUMROOM
#define EAX30_PRESET_SPACESTATION_SHORTPASSAGE REVERB_PRESET_SPACESTATION_SHORTPASSAGE
#define EAX30_PRESET_SPACESTATION_LONGPASSAGE REVERB_PRESET_SPACESTATION_LONGPASSAGE
#define EAX30_PRESET_SPACESTATION_LARGEROOM REVERB_PRESET_SPACESTATION_LARGEROOM
#define EAX30_PRESET_SPACESTATION_HALL REVERB_PRESET_SPACESTATION_HALL
#define EAX30_PRESET_SPACESTATION_CUPBOARD REVERB_PRESET_SPACESTATION_CUPBOARD
#define EAX30_PRESET_SPACESTATION_SMALLROOM REVERB_PRESET_SPACESTATION_SMALLROOM

#define EAX30_PRESET_WOODEN_ALCOVE REVERB_PRESET_WOODEN_ALCOVE
#define EAX30_PRESET_WOODEN_SHORTPASSAGE REVERB_PRESET_WOODEN_SHORTPASSAGE
#define EAX30_PRESET_WOODEN_MEDIUMROOM REVERB_PRESET_WOODEN_MEDIUMROOM
#define EAX30_PRESET_WOODEN_LONGPASSAGE REVERB_PRESET_WOODEN_LONGPASSAGE
#define EAX30_PRESET_WOODEN_LARGEROOM REVERB_PRESET_WOODEN_LARGEROOM
#define EAX30_PRESET_WOODEN_HALL REVERB_PRESET_WOODEN_HALL
#define EAX30_PRESET_WOODEN_CUPBOARD REVERB_PRESET_WOODEN_CUPBOARD
#define EAX30_PRESET_WOODEN_SMALLROOM REVERB_PRESET_WOODEN_SMALLROOM
#define EAX30_PRESET_WOODEN_COURTYARD REVERB_PRESET_WOODEN_COURTYARD

#define EAX30_PRESET_SPORT_EMPTYSTADIUM REVERB_PRESET_SPORT_EMPTYSTADIUM
#define EAX30_PRESET_SPORT_SQUASHCOURT REVERB_PRESET_SPORT_SQUASHCOURT
#define EAX30_PRESET_SPORT_SMALLSWIMMINGPOOL REVERB_PRESET_SPORT_SMALLSWIMMINGPOOL
#define EAX30_PRESET_SPORT_LARGESWIMMINGPOOL REVERB_PRESET_SPORT_LARGESWIMMINGPOOL
#define EAX30_PRESET_SPORT_GYMNASIUM REVERB_PRESET_SPORT_GYMNASIUM
#define EAX30_PRESET_SPORT_FULLSTADIUM REVERB_PRESET_SPORT_FULLSTADIUM
#define EAX30_PRESET_SPORT_STADIUMTANNOY REVERB_PRESET_SPORT_STADIUMTANNOY

#define EAX30_PRESET_PREFAB_WORKSHOP REVERB_PRESET_PREFAB_WORKSHOP
#define EAX30_PRESET_PREFAB_SCHOOLROOM REVERB_PRESET_PREFAB_SCHOOLROOM
#define EAX30_PRESET_PREFAB_PRACTISEROOM REVERB_PRESET_PREFAB_PRACTISEROOM
#define EAX30_PRESET_PREFAB_OUTHOUSE REVERB_PRESET_PREFAB_OUTHOUSE
#define EAX30_PRESET_PREFAB_CARAVAN REVERB_PRESET_PREFAB_CARAVAN

#define EAX30_PRESET_DOME_TOMB REVERB_PRESET_DOME_TOMB
#define EAX30_PRESET_PIPE_SMALL REVERB_PRESET_PIPE_SMALL
#define EAX30_PRESET_DOME_SAINTPAULS REVERB_PRESET_DOME_SAINTPAULS
#define EAX30_PRESET_PIPE_LONGTHIN REVERB_PRESET_PIPE_LONGTHIN
#define EAX30_PRESET_PIPE_LARGE REVERB_PRESET_PIPE_LARGE
#define EAX30_PRESET_PIPE_RESONANT REVERB_PRESET_PIPE_RESONANT

#define EAX30_PRESET_OUTDOORS_BACKYARD REVERB_PRESET_OUTDOORS_BACKYARD
#define EAX30_PRESET_OUTDOORS_ROLLINGPLAINS REVERB_PRESET_OUTDOORS_ROLLINGPLAINS
#define EAX30_PRESET_OUTDOORS_DEEPCANYON REVERB_PRESET_OUTDOORS_DEEPCANYON
#define EAX30_PRESET_OUTDOORS_CREEK REVERB_PRESET_OUTDOORS_CREEK
#define EAX30_PRESET_OUTDOORS_VALLEY REVERB_PRESET_OUTDOORS_VALLEY

#define EAX30_PRESET_MOOD_HEAVEN REVERB_PRESET_MOOD_HEAVEN
#define EAX30_PRESET_MOOD_HELL REVERB_PRESET_MOOD_HELL
#define EAX30_PRESET_MOOD_MEMORY REVERB_PRESET_MOOD_MEMORY

#define EAX30_PRESET_DRIVING_COMMENTATOR REVERB_PRESET_DRIVING_COMMENTATOR
#define EAX30_PRESET_DRIVING_PITGARAGE REVERB_PRESET_DRIVING_PITGARAGE
#define EAX30_PRESET_DRIVING_INCAR_RACER REVERB_PRESET_DRIVING_INCAR_RACER
#define EAX30_PRESET_DRIVING_INCAR_SPORTS REVERB_PRESET_DRIVING_INCAR_SPORTS
#define EAX30_PRESET_DRIVING_INCAR_LUXURY REVERB_PRESET_DRIVING_INCAR_LUXURY
#define EAX30_PRESET_DRIVING_FULLGRANDSTAND REVERB_PRESET_DRIVING_FULLGRANDSTAND
#define EAX30_PRESET_DRIVING_EMPTYGRANDSTAND REVERB_PRESET_DRIVING_EMPTYGRANDSTAND
#define EAX30_PRESET_DRIVING_TUNNEL REVERB_PRESET_DRIVING_TUNNEL

#define EAX30_PRESET_CITY_STREETS REVERB_PRESET_CITY_STREETS
#define EAX30_PRESET_CITY_SUBWAY REVERB_PRESET_CITY_SUBWAY
#define EAX30_PRESET_CITY_MUSEUM REVERB_PRESET_CITY_MUSEUM
#define EAX30_PRESET_CITY_LIBRARY REVERB_PRESET_CITY_LIBRARY
#define EAX30_PRESET_CITY_UNDERPASS REVERB_PRESET_CITY_UNDERPASS
#define EAX30_PRESET_CITY_ABANDONED REVERB_PRESET_CITY_ABANDONED

#define EAX30_PRESET_DUSTYROOM REVERB_PRESET_DUSTYROOM
#define EAX30_PRESET_CHAPEL REVERB_PRESET_CHAPEL
#define EAX30_PRESET_SMALLWATERROOM REVERB_PRESET_SMALLWATERROOM

#define	EAX30_SCENARIO_CASTLE REVERB_SCENARIO_CASTLE
#define	EAX30_SCENARIO_FACTORY REVERB_SCENARIO_FACTORY
#define	EAX30_SCENARIO_ICEPALACE REVERB_SCENARIO_ICEPALACE
#define	EAX30_SCENARIO_SPACESTATION REVERB_SCENARIO_SPACESTATION 
#define	EAX30_SCENARIO_WOODGALLEON REVERB_SCENARIO_WOODGALLEON
#define	EAX30_SCENARIO_SPORTS REVERB_SCENARIO_SPORTS
#define	EAX30_SCENARIO_PREFAB REVERB_SCENARIO_PREFAB
#define	EAX30_SCENARIO_DOMESNPIPES REVERB_SCENARIO_DOMESNPIPES
#define	EAX30_SCENARIO_OUTDOORS REVERB_SCENARIO_OUTDOORS
#define	EAX30_SCENARIO_MOOD REVERB_SCENARIO_MOOD
#define	EAX30_SCENARIO_DRIVING REVERB_SCENARIO_DRIVING
#define	EAX30_SCENARIO_CITY REVERB_SCENARIO_CITY
#define	EAX30_SCENARIO_MISC REVERB_SCENARIO_MISC
#define	EAX30_SCENARIO_ORIGINAL REVERB_SCENARIO_ORIGINAL
#define	EAX30_SCENARIO REVERB_SCENARIO

#define EAX30_NUM_SCENARIOS REVERB_NUM_SCENARIOS
#define EAX30_SCENARIO_NAMES REVERB_SCENARIO_NAMES
#define EAX30_NUM_STANDARD_SCENARIOS REVERB_NUM_STANDARD_SCENARIOS

#define	EAX30_LOCATION_HALL REVERB_LOCATION_HALL
#define	EAX30_LOCATION_LARGEROOM REVERB_LOCATION_LARGEROOM
#define	EAX30_LOCATION_MEDIUMROOM REVERB_LOCATION_MEDIUMROOM
#define	EAX30_LOCATION_SMALLROOM REVERB_LOCATION_SMALLROOM
#define	EAX30_LOCATION_CUPBOARD REVERB_LOCATION_CUPBOARD
#define	EAX30_LOCATION_ALCOVE REVERB_LOCATION_ALCOVE
#define	EAX30_LOCATION_LONGPASSAGE REVERB_LOCATION_LONGPASSAGE
#define	EAX30_LOCATION_SHORTPASSAGE REVERB_LOCATION_SHORTPASSAGE
#define	EAX30_LOCATION_COURTYARD REVERB_LOCATION_COURTYARD
#define EAX30_LOCATION REVERB_LOCATION

#define EAX30_NUM_LOCATIONS	REVERB_NUM_LOCATIONS	
#define EAX30_LOCATION_NAMES REVERB_LOCATION_NAMES

#define EAX30_NUM_ORIGINAL_PRESETS REVERB_NUM_ORIGINAL_PRESETS
#define EAX30_NUM_CASTLE_PRESETS REVERB_NUM_CASTLE_PRESETS
#define EAX30_NUM_FACTORY_PRESETS REVERB_NUM_FACTORY_PRESETS
#define EAX30_NUM_ICEPALACE_PRESETS	REVERB_NUM_ICEPALACE_PRESETS
#define EAX30_NUM_SPACESTATION_PRESETS REVERB_NUM_SPACESTATION_PRESETS
#define EAX30_NUM_WOODGALLEON_PRESETS REVERB_NUM_WOODGALLEON_PRESETS
#define EAX30_NUM_SPORTS_PRESETS REVERB_NUM_SPORTS_PRESETS
#define EAX30_NUM_PREFAB_PRESETS REVERB_NUM_PREFAB_PRESETS
#define EAX30_NUM_DOMESNPIPES_PRESETS REVERB_NUM_DOMESNPIPES_PRESETS
#define EAX30_NUM_OUTDOORS_PRESETS REVERB_NUM_OUTDOORS_PRESETS
#define EAX30_NUM_MOOD_PRESETS REVERB_NUM_MOOD_PRESETS
#define EAX30_NUM_DRIVING_PRESETS REVERB_NUM_DRIVING_PRESETS
#define EAX30_NUM_CITY_PRESETS REVERB_NUM_CITY_PRESETS
#define EAX30_NUM_MISC_PRESETS REVERB_NUM_MISC_PRESETS

#define EAX30_STANDARD_PRESETS REVERB_STANDARD_PRESETS

#define EAX30_ORIGINAL_PRESET_ENUMS REVERB_ORIGINAL_PRESET_ENUMS
#define EAX30_ORIGINAL_PRESET_NAMES REVERB_ORIGINAL_PRESET_NAMES
#define EAX30_ORIGINAL_PRESETS REVERB_ORIGINAL_PRESETS

#define EAX30_SPORTS_PRESET_ENUMS REVERB_SPORTS_PRESET_ENUMS
#define EAX30_SPORTS_PRESET_NAMES REVERB_SPORTS_PRESET_NAMES
#define EAX30_SPORTS_PRESETS REVERB_SPORTS_PRESETS

#define EAX30_PREFAB_PRESET_ENUMS REVERB_PREFAB_PRESET_ENUMS
#define EAX30_PREFAB_PRESET_NAMES REVERB_PREFAB_PRESET_NAMES
#define EAX30_PREFAB_PRESETS REVERB_PREFAB_PRESETS

#define EAX30_DOMESNPIPES_PRESET_ENUMS REVERB_DOMESNPIPES_PRESET_ENUMS
#define EAX30_DOMESNPIPES_PRESET_NAMES REVERB_DOMESNPIPES_PRESET_NAMES
#define EAX30_DOMESNPIPES_PRESETS REVERB_DOMESNPIPES_PRESETS

#define EAX30_OUTDOORS_PRESET_ENUMS REVERB_OUTDOORS_PRESET_ENUMS
#define EAX30_OUTDOORS_PRESET_NAMES REVERB_OUTDOORS_PRESET_NAMES
#define EAX30_OUTDOORS_PRESETS REVERB_OUTDOORS_PRESETS

#define EAX30_MOOD_PRESET_ENUMS REVERB_MOOD_PRESET_ENUMS
#define EAX30_MOOD_PRESET_NAMES REVERB_MOOD_PRESET_NAMES
#define EAX30_MOOD_PRESETS REVERB_MOOD_PRESETS

#define EAX30_DRIVING_PRESET_ENUMS REVERB_DRIVING_PRESET_ENUMS
#define EAX30_DRIVING_PRESET_NAMES REVERB_DRIVING_PRESET_NAMES
#define EAX30_DRIVING_PRESETS REVERB_DRIVING_PRESETS

#define EAX30_CITY_PRESET_ENUMS REVERB_CITY_PRESET_ENUMS
#define EAX30_CITY_PRESET_NAMES REVERB_CITY_PRESET_NAMES
#define EAX30_CITY_PRESETS REVERB_CITY_PRESETS

#define EAX30_MISC_PRESET_ENUMS REVERB_MISC_PRESET_ENUMS
#define EAX30_MISC_PRESET_NAMES REVERB_MISC_PRESET_NAMES
#define EAX30_MISC_PRESETS REVERB_MISC_PRESETS
////////////////////////////////////////////////////////////////////////////