#!/usr/bin/perl

$routine = 'Routine';
$vec = 'Vector4';

processArgument(shift(@ARGV)) while(@ARGV);
pass2();

print "// FILE AUTOMATICALLY GENERATED BY vcl2cpp.pl\n";
print "//\n";
print "\n";
$vecs{"vf00"}++;
print "// " . keys(%vecs) . " vectors:\n";
print "$vec " . join(',', keys(%vecs)) . ";\n";

print "// " . keys(%ints) . " shorts:\n";
print "unsigned short " . join(',', keys(%ints)) . ";\n";



$~ = header;
write;
%fieldshift = ( X => 3, Y => 2, Z => 1, W => 0);
for (qw/X XY XYZ XYZW Y YZ YZW Z ZW XZ XZW XW YW/){
  $fields = $_;
  $~ = fmsethead;
  write;
  $~ = fmsetbody;
  foreach (split //){
#	  $_ = lc;
	  write;
  }
  $~ = fmsettail;
  write;
}

$~ = routine;
write;

dumpFile();

print "\n}\n";

sub pass2 {
  foreach (@output){
	 next if /###/;
	 s/\[x\]/.X()/g;
	 s/\[y\]/.Y()/g;
	 s/\[z\]/.Z()/g;
	 s/\[w\]/.W()/g;
	 s/Math\:\:IntAsFloat\(0\)/0.0f/g;
	 s/vf0.X\(\)/0.0f/g;
	 s/vf0.Y\(\)/0.0f/g;
	 s/vf0.Z\(\)/0.0f/g;
	 s/vf0.W\(\)/1.0f/g;
	 s/(DoFMSET[XYZ]+\(.*)vf0\s([+-])/$1$2/g;
 	 s/\.Set([XYZW]+)/.$1/g;
	 s/\.XYZW/.Set/g;
  }
}

sub dumpFile {
  print join("\n", @output);
}

sub append {
  $_[1] = 1 if !defined($_[1]);
  $line = "\t" x $_[1] . $_[0];
  push(@output, $line);
}

sub processArgument {
 if(substr($_[0], 0, 2) eq '-i') {
	push(@includepaths, substr($_[0], 2));
 } else {
	processFile($_[0], 'fh00');
 }
}

sub pushvec {
  foreach (@_){
	 next if /^q$/;
	 next if /^i$/;
	 next if /^p$/;
	 next if /^r$/;
	 my $a = $_;
	 $a =~ s/\[(?:x|y|z|w)\]//;
	 next if $a=~/^\s*$/;
	 $a =~ s/\[([^\]]*)\]/_$1_/g;
	 $vecs{$a}++;
  }
}
sub pushint {
  foreach (@_){
	 next if /^[\s\d\+\-]+$/;
	 next if /^0x/;
	 next if /^vi0$/;
	 next if /^\s*$/;
	 my $a = $_;
	 $a =~ s/\[([^\]]*)\]/_$1_/g;
	 $ints{$a}++;
  }
}

sub processFile {
  my($file, $handle) = @_;
  $file = $1 if $file =~ /"(.*)"/;
  $handle++;

  unless(openfile($file, $handle)) {
	 print STDERR "Cant open file $file\n";
	 return;
  }

  local $_;
  while(<$handle>){
	 chomp();

	 s/;.*$//;
	 next if /^\s*$/;
	 next if /--endenter/i;
	 next if /--endexit/i;
	 next if /enter/i;
	 next if /exit/i;
	 next if /--loopcs/i;

	 if(/.include \"(.*)\"/){
		processFile($1, $handle);
		next;
	 }
	
	 $routine = $1 . '_VCL' if /.name\s+(\w+)/;

	 append "// ### $_";

	 $_ = lc;
	 s/vf0(\d)/vf$1/gi;
	 s/vi0(\d)/vi$1/gi;
	 s/vi0/0/gi;

	 # misc
	 append "" if /^\s+nop\s*$/i;
	 if(/^\s+xitop\s+([\w\[\]]+)\s*$/i){
		append "$1 = xitop;";
		pushint $1;
	 }
	 if(/^\s+xtop\s+([\w\[\]]+)\s*$/i){
		append "$1 = xtop;";
		pushint $1;
	 }
	 if(/^\s+xgkick\s+([\w\[\]]+)\s*$/i){
		append "XGKICK(vumem, $1);";
		pushint $1;
	 }

	 # flow control
	 if(/^\s*(\w+):\s*/i){
		append "$1(vumem,xtop,xitop);";
		append "}",0;
		append "static void $1(u128* vumem, short xtop, short xitop){",0;
	 }
	 if(/^\s+b\s+([\w\[\]]+)\s*$/i){
		append "$1(vumem,xtop,xitop);return;";
	 }
	 if(/^\s+ibeq\s+([\w\[\]]+)\s*,\s*([\w\[\]]+)\s*,\s*([\w\[\]]+)\s*$/i){
		append "if($1 == $2) { $3(vumem,xtop,xitop); return; }";
		pushint $1, $2;
	 }
	 if(/^\s+ibne\s+([\w\[\]]+)\s*,\s*([\w\[\]]+)\s*,\s*([\w\[\]]+)\s*$/i){
		append "if($1 != $2) { $3(vumem,xtop,xitop); return; }";
		pushint $1, $2;
	 }
	 if(/^\s+ibgtz\s+([\w\[\]]+)\s*,\s*([\w\[\]]+)\s*$/i){
		append "if($1 > 0) { $2(vumem,xtop,xitop); return; }";
		pushint $1;
	 }
	 if(/^\s+ibltz\s+([\w\[\]]+)\s*,\s*([\w\[\]]+)\s*$/i){
		append "if($1 < 0) { $2(vumem,xtop,xitop); return; }";
		pushint $1;
	 }
	 if(/^\s+ibgez\s+([\w\[\]]+)\s*,\s*([\w\[\]]+)\s*$/i){
		append "if($1 >= 0) { $2(vumem,xtop,xitop); return; }";
		pushint $1;
	 }
	 if(/^\s+iblez\s+([\w\[\]]+)\s*,\s*([\w\[\]]+)\s*$/i){
		append "if($1 <= 0) { $2(vumem,xtop,xitop); return; }";
		pushint $1;
	 }
	 if(/^\s+bal\s+([\w\[\]]+)\s*,\s*([\w\[\]]+)\s*$/i){
		append "$2(vumem,xtop,xitop);";
		pushint $1;
	 }
	 if(/^\s+jr\s+([\w\[\]]+)\s*$/i){
		append "return;";
		pushint $1;
	 }
	 if(/^\s+jalr\s+([\w\[\]]+)\s*,\s*([\w\[\]]+)\s*$/i){
		append "jalr? not sure what to do.";
		pushint $1,$2;
	 }

	 # I register
	 if(/^\s+loi\s+(\d*\.\d*)\s*$/i){
		append "I = $1;";
	 }
	 if(/^\s+loi\s+(0x[\da-f]*)\s*$/i){
		append "I = Math::IntAsFloat($1);";
	 }

	 # R register
	 if(/^\s+rinit\s+r\s*,\s*([\w\[\]]+)\s*$/i){
		append "R = IntAsFloat((FloatAsInt($1) & 0x007FFFFF) | 0x78000000);";
		pushvec $1;
	 }
	 if(/^\s+rnext\.?([xyzw]*)\s+([\w\[\]]+)\s*,\s*R\s*$/i){
		append "R = IntAsFloat((rand() & 0x007FFFFF) | 0x78000000);";
	 }
	 if(/^\s+(?:rget|rnext)\.?([xyzw]*)\s+([\w\[\]]+)\s*,\s*R\s*$/i){
		append "$2.Set" . uc($1) . "(R);";
		pushvec $2;
	 }
	 if(/^\s+rxor\s+r\s*,\s*([\w\[\]]+)\s*$/i){
		append "R = IntAsFloat((FloatAsInt($1) & 0x007FFFFF) ^ IntAsFloat(R));";
		pushvec $1;
	 }

	 # float min/max
	 if(/^\s+minii?\.?([xyzw]*)\s+([\w\[\]]+)\s*,\s*([\w\[\]]+)\s*,\s*([\w\[\]]+)\s*$/i){
		append "$2.Set" . uc($1) . "(Vector4::Min($3, $4));";
		pushvec $2, $3, $4;
	 }
	 if(/^\s+maxi?\.?([xyzw]*)\s+([\w\[\]]+)\s*,\s*([\w\[\]]+)\s*,\s*([\w\[\]]+)\s*$/i){
		append "$2.Set" . uc($1) . "(Vector4::Max($3, $4));";
		pushvec $2, $3, $4;
	 }

	 # float conversion
	 if(/^\s+ftoi(0|4|12|15)\.?([xyzw]*)\s+([\w\[\]]+)\s*,\s*([\w\[\]]+)\s*$/i){
		append "$3.Set" . uc($2) . "(Math::IntAsFloat((int)($4.x()*(1<<$1))), Math::IntAsFloat((int)($4.y()*(1<<$1))), Math::IntAsFloat((int)($4.z()*(1<<$1))), Math::IntAsFloat((int)($4.w()*(1<<$1))));";
		pushvec $3, $4;
	 }
	 if(/^\s+itof(0|4|12|15)\.?([xyzw]*)\s+([\w\[\]]+)\s*,\s*([\w\[\]]+)\s*$/i){
		append "$3.Set" . uc($2) . "((float)Math::FloatAsInt($4.x())/(1<<$1),(float)Math::FloatAsInt($4.y())/(1<<$1),(float)Math::FloatAsInt($4.z())/(1<<$1),(float)Math::FloatAsInt($4.w())/(1<<$1));";
		pushvec $3, $4;
	 }
	
	 # float EFU unit
	 if(/^\s+mfp\.?([xyzw]*)\s+([\w\[\]]+)\s*,\s*P\s*$/i){
		append "$2.Set" . uc($1) . "(P);";
		pushvec $2;
	 }
	 if(/^\s+eleng\s*P\s*,\s*([\w\[\]]+)\s*$/i){
		append "P = $1.Length();";
		pushvec $1;
	 }
	 if(/^\s+esqrt\s*P\s*,\s*([\w\[\]]+)\s*$/i){
		append "P = Math::Sqrt($1);";
		pushvec $1;
	 }
	 if(/^\s+esum\s*P\s*,\s*([\w\[\]]+)\s*$/i){
		append "P = $1.x() + $1.y() + $1.z() + $1.w();";
		pushvec $1;
	 }
	 if(/^\s+eatan\s*P\s*,\s*([\w\[\]]+)\s*$/i){
		append "P = Math::ATan($1);";
		pushvec $1;
	 }
	 if(/^\s+eatanxy\s*P\s*,\s*([\w\[\]]+)\s*$/i){
		append "P = Math::ATan2($1.x(), $1.y());";
		pushvec $1;
	 }
	 if(/^\s+eatanxz\s*P\s*,\s*([\w\[\]]+)\s*$/i){
		append "P = Math::ATan2($1.x(), $1.z());";
		pushvec $1;
	 }
	 if(/^\s+eexp\s*P\s*,\s*([\w\[\]]+)\s*$/i){
		append "P = Math::Exp(-$1);";
		pushvec $1;
	 }
	 if(/^\s+ercpr\s*P\s*,\s*([\w\[\]]+)\s*$/i){
		append "P = 1.0f / $1;";
		pushvec $1;
	 }
	 if(/^\s+erleng\s*P\s*,\s*([\w\[\]]+)\s*$/i){
		append "P = 1.0f / $1.Length();";
		pushvec $1;
	 }
	 if(/^\s+ersqrt\s*P\s*,\s*([\w\[\]]+)\s*$/i){
		append "P = 1.0f / Math::Sqrt($1);";
		pushvec $1;
	 }
	 if(/^\s+esin\s*P\s*,\s*([\w\[\]]+)\s*$/i){
		append "P = Math::Sin($1);";
		pushvec $1;
	 }
	 if(/^\s+esadd\s*P\s*,\s*([\w\[\]]+)\s*$/i){
		append "{ Vector4 sq = $1 * $1; P = sq.x() + sq.y() + sq.z(); }";
		pushvec $1;
	 }
	 if(/^\s+ersadd\s*P\s*,\s*([\w\[\]]+)\s*$/i){
		append "{ Vector4 sq = $1 * $1; P = 1.0f / (sq.x() + sq.y() + sq.z()); }";
		pushvec $1;
	 }

	 # float moves
	 if(/^\s+move\.?([xyzw]*)\s+([\w\[\]]+)\s*,\s*([\w\[\]]+)\s*$/i){
		append "$2.Set" . uc($1) . "($3);";
		pushvec $2, $3;
	 }
	 if(/^\s+mr32\.?([xyzw]*)\s+([\w\[\]]+)\s*,\s*([\w\[\]]+)\s*$/i){
		append "$2.Set" . uc($1) . "($3.RotateLeft());";
		pushvec $2, $3;
	 }

	 # float div
	 if(/^\s+div\s+q\s*,\s*([\w\[\]]+)\s*,\s*([\w\[\]]+)\s*$/i){
		append "Q = $1 / $2;";
		pushvec $1, $2;
	 }
	 if(/^\s+sqrt\s+q\s*,\s*([\w\[\]]+)\s*$/i){
		append "Q = Math::Sqrt($1);";
		pushvec $1;
	 }
	 if(/^\s+rsqrt\s+q\s*,\s*([\w\[\]]+)\s*,\s*([\w\[\]]+)\s*$/i){
		append "Q = Math::Sqrt($1 / $2);";
		pushvec $1, $2;
	 }

	 # mfir/mtir
	 if(/^\s+mfir\.?([xyzw]*)?\s+([\w\[\]]+)\s*,\s*([\w\[\]]+)\s*$/i){
		append "$2.Set" . uc($1) . "(Math::IntAsFloat($3));";
		pushvec $2;
		pushint $3;
	 }
	 if(/^\s+mtir\s+([\w\[\]]+)\s*,\s*([\w\[\]]+)\s*$/i){
		append "$1 = (unsigned short)Math::FloatAsInt($2);";
		pushvec $2;
		pushint $1;
	 }

	 # float math
	 if(/^\s+abs\.?([xyzw]*)\s+([\w\[\]]+)\s*,\s*([\w\[\]]+)\s*$/i){
		append "$2.Set" . uc($1) . "($3.Abs());";
		pushvec $2, $3;
	 }
	 if(/^\s+add(?:[qai])?\.?([xyzw]*)\s+([\w\[\]]+)\s*,\s*([\w\[\]]+)\s*,\s*([\w\[\]]+)\s*$/i){
		append "DoFMSET" . uc($1) . "($2, $3 + $4);";
		pushvec $2, $3, $4;
	 }
	 if(/^\s+sub(?:[qai])?\.?([xyzw]*)\s+([\w\[\]]+)\s*,\s*([\w\[\]]+)\s*,\s*([\w\[\]]+)\s*$/i){
		append "DoFMSET" . uc($1) . "($2, $3 - $4);";
		pushvec $2, $3, $4;
	 }
	 if(/^\s+mul(?:[qai])?\.?([xyzw]*)\s+([\w\[\]]+)\s*,\s*([\w\[\]]+)\s*,\s*([\w\[\]]+)\s*$/i){
		append "DoFMSET" . uc($1) . "($2, $3 * $4);";
		pushvec $2, $3, $4;
	 }
	 if(/^\s+madd(?:[qai])?\.?([xyzw]*)\s+([\w\[\]]+)\s*,\s*([\w\[\]]+)\s*,\s*([\w\[\]]+)\s*$/i){
		append "DoFMSET" . uc($1) . "($2, acc + $3 * $4);";
		pushvec $2, $3, $4;
	 }
	 if(/^\s+msub(?:[qai])?\.?([xyzw]*)\s+([\w\[\]]+)\s*,\s*([\w\[\]]+)\s*,\s*([\w\[\]]+)\s*$/i){
		append "DoFMSET" . uc($1) . "($2, acc - $3 * $4);";
		pushvec $2, $3, $4;
	 }
	 if(/^\s+opmula(?:\.xyz)?\s+(?:[\w\[\]]+)\s*,\s*([\w\[\]]+)\s*,\s*([\w\[\]]+)\s*$/i){
		append "DoFMSETXYZ(acc, $1.y() * $2.z(), $1.z() * $2.x(), $1.x() * $2.y());";
		pushvec $1, $2, "acc";
	 }
	 if(/^\s+opmsub(?:\.xyz)?\s+(?:[\w\[\]]+)\s*,\s*([\w\[\]]+)\s*,\s*([\w\[\]]+)\s*$/i){
		append "DoFMSETXYZ($1, acc.x() - $1.y() * $2.z(), acc.y() - $1.z() * $2.x(), acc.z() - $1.x() * $2.y());";
		pushvec $1, $2, "acc";
	 }

	 # float flags
	 if(/^\s+fmand\s+([\w\[\]]+)\s*,\s*([\w\[\]]+)\s*$/i){
		append "$1 = FM & $2";
		pushint $1, $2;
	 }
	 if(/^\s+fmor\s+([\w\[\]]+)\s*,\s*([\w\[\]]+)\s*$/i){
		append "$1 = FM | $2";
		pushint $1, $2;
	 }
	 if(/^\s+fmeq\s+([\w\[\]]+)\s*,\s*([\w\[\]]+)\s*$/i){
		append "$1 = FM == $2";
		pushint $1, $2;
	 }
	 if(/^\s+fsand\s+([\w\[\]]+)\s*,\s*([\w\[\]]+)\s*$/i){
		append "no stickys... since VCL doesnt support them, neither will we.";
	 }
	 if(/^\s+fsor\s+([\w\[\]]+)\s*,\s*([\w\[\]]+)\s*$/i){
		append "no stickys... since VCL doesnt support them, neither will we.";
	 }
	 if(/^\s+fseq\s+([\w\[\]]+)\s*,\s*([\w\[\]]+)\s*$/i){
		append "no stickys... since VCL doesnt support them, neither will we.";
	 }
	 if(/^\s+fsset\s+([\w\[\]]+)\s*,\s*([\w\[\]]+)\s*$/i){
		append "no stickys... since VCL doesnt support them, neither will we.";
	 }

	 # float loads & stores
	 if(/^\s+lq\.?([xyzw]*)\s+([^\s,]+)\s*,\s*(.*)\s*\((.*)\).*$/i){
		append "$2.Set" . uc($1) . "(vumem" . "[$3 + $4]);";
		pushvec $2;
		pushint $3, $4;
	 }
	 if(/^\s+sq\.?([xyzw]*)\s+([^\s,]+)\s*,\s*(.*)\s*\((.*)\).*$/i){
		append "vumem" . "[$3 + $4].Set" . uc($1) . "($2);";
		pushvec $2;
		pushint $3, $4;
	 }
	 if(/^\s+lqi\.?([xyzw]*)\s+([^\s,]+)\s*,\s*\((.*)\s*\+\+\s*\).*$/i){
		append "$2.Set" . uc($1) . "(vumem" . "[$3++]);";
		pushvec $2;
		pushint $3;
	 }
	 if(/^\s+sqi\.?([xyzw]*)\s+([^\s,]+)\s*,\s*\((.*)\s*\+\+\s*\).*$/i){
		append "vumem" . "[$3++].Set" . uc($1) . "($2);";
		pushvec $2;
		pushint $3;
	 }
	 if(/^\s+lqd\.?([xyzw]*)\s+([^\s,]+)\s*,\s*\(\s*\-\-\s*(.*)\).*$/i){
		append "$2.Set" . uc($1) . "(vumem" . "[--$3]);";
		pushvec $2;
		pushint $3;
	 }
	 if(/^\s+sqd\.?([xyzw]*)\s+([^\s,]+)\s*,\s*\(\s*\-\-\s*(.*)\).*$/i){
		append "vumem" . "[--$3].Set" . uc($1) . "($2);";
		pushvec $2;
		pushint $3;
	 }

	 # integer loads & stores
	 if(/^\s+isw\.?([xyzw]*)\s+([^\s,]+)\s*,\s*(.*)\s*\((.*)\).*$/i){
		append "vumem" . "[$3 + $4].Set" . uc($1) . "(Math::IntAsFloat($2));";
		pushint $2, $3, $4;
	 }
	 if(/^\s+ilw\.?([xyzw])\s+([^\s,]+)\s*,\s*(.*)\s*\((.*)\).*$/i){
		append "$2 = Math::FloatAsInt(vumem" . "[$3 + $4]." . lc($1) . "());";
		pushint $2, $3, $4;
	 }
	 if(/^\s+iswr\.?([xyzw]*)\s+([^\s,]+)\s*,\s*(.*)\s*\((.*)\).*$/i){
		append "vumem" . "[$3].Set" . uc($1) . "(Math::IntAsFloat($2));";
		pushint $2, $3, $4;
	 }
	 if(/^\s+ilwr\.?([xyzw])\s+([^\s,]+)\s*,\s*(.*)\s*\((.*)\).*$/i){
		append "$2 = Math::FloatAsInt(vumem" . "[$3]." . lc($1) . "());";
		pushint $2, $3, $4;
	 }

	 # integer math
	 if(/^\s+iadd(?:iu)?\s+([\w\[\]]+)\s*,\s*([\w\[\]]+)\s*,\s*([\w\[\]]+)\s*$/i){
		append "$1 = $2 + (unsigned)$3;";
		pushint $1, $2, $3;
	 }
	 if(/^\s+isub(?:iu)?\s+([\w\[\]]+)\s*,\s*([\w\[\]]+)\s*,\s*([\w\[\]]+)\s*$/i){
		append "$1 = $2 - (unsigned)$3;";
		pushint $1, $2, $3;
	 }
	 if(/^\s+iaddi\s+([\w\[\]]+)\s*,\s*([\w\[\]]+)\s*,\s*([\w\[\]]+)\s*$/i){
		append "$1 = (signed)$2 + (signed)$3;";
		pushint $1, $2, $3;
	 }
	 if(/^\s+isubi\s+([\w\[\]]+)\s*,\s*([\w\[\]]+)\s*,\s*([\w\[\]]+)\s*$/i){
		append "$1 = (signed)$2 - (signed)$3;";
		pushint $1, $2, $3;
	 }
	 if(/^\s+iand\s+([\w\[\]]+)\s*,\s*([\w\[\]]+)\s*,\s*([\w\[\]]+)\s*$/i){
		append "$1 = $2 & $3;";
		pushint $1, $2, $3;
	 }
	 if(/^\s+ior\s+([\w\[\]]+)\s*,\s*([\w\[\]]+)\s*,\s*([\w\[\]]+)\s*$/i){
		append "$1 = $2 | $3;";
		pushint $1, $2, $3;
	 }

	 # clip flag
	 if(/^\s+clipw?(?:.xyz)?\s+([\w\[\]]*)\s*,\s*([\w\[\]]*)\s*$/i){
		append "Clip($1,$2);";
		pushvec $1, $2;
	 }
	 if(/^\s+fcset\s+(\w*)\s*$/i){
		append "FC = $1;";
	 }
	 if(/^\s+fcand\s+([\w\[\]]+)\s*,\s*([\w\[\]]+)\s*$/i){
		append "$1 = (FC & $2) ? 1 : 0;";
		pushint $1;
	 }
	 if(/^\s+fceq\s+([\w\[\]]+)\s*,\s*([\w\[\]]+)\s*$/i){
		append "$1 = (FC == $2);";
		pushint $1;
	 }
	 if(/^\s+fcget\s+([\w\[\]]+)\s*$/i){
		append "$1 = FC;";
		pushint $1;
	 }
	 if(/^\s+fcor\s+([\w\[\]]+)\s*,\s*([\w\[\]]+)\s*$/i){
		append "$1 = ((FC | $2) == $2) ? 1 : 0;";
		pushint $1;
	 }
  }
}

sub openfile {
  my($file, $handle) = @_;

  return 1 if open($handle, $file);
  foreach (@includepaths) {
	 return 1 if open($handle, $_ . '/' . $file);
  }
  return 0;
}

sub evalequ {
  foreach (keys(%equates)){
	 $_[0] =~ s/$_/$equates{$_}/g;
  }
  return $_[0];
}

sub swapXYZW {
  return "Set" if $_[0] =~ /XYZW/;
  return $_[0];
}


format fmsethead =
static void DoFMSET@<<<(@>>>>>>& dest, @>>>>>>> val)
$_, $vec, $vec
{
	dest.@<<<(val);
swapXYZW($_)
.
format fmsetbody =
	FM &= 0x1111 << @<<;
$fieldshift{$_}
	float t = dest.@();
$_
   if(t == 0.0f) FM |= 0x0001 << @<<;
$fieldshift{$_}
	if(t < 0.0f) FM |= 0x0010 << @<<;
$fieldshift{$_}
	if(t == Math::NegativeInfinity) FM |= 0x0100 << @<<;
$fieldshift{$_}
	if(t == Math::PositiveInfinity) FM |= 0x1000 << @<<;
$fieldshift{$_}
.
format fmsettail =
@
"}"
.

format header =

float R, Q, I, P;
u32 FC, FS, FM;

static void Clip(@>>>>>> lhs, @>>>>>> rhs)
$vec, $vec
{
	float w = Math::Abs(rhs.W());
	FC = (FC << 6) & 0xFFFFFF;

	if(lhs.X() > w)
		FC |= 0x000001;
   if(lhs.X() < -w)
      FC |= 0x000002;
	if(lhs.Y() > w)
		FC |= 0x000004;
   if(lhs.Y() < -w)
      FC |= 0x000008;
	if(lhs.Z() > w)
		FC |= 0x000010;
   if(lhs.Z() < -w)
      FC |= 0x000020;
@
"}"
.
format routine =
void @>>>>>>>>>>>>(@>>>>>>* vumem, short xtop, short xitop)
$routine, $vec
{
	vf0.Set(0.0f, 0.0f, 0.0f, 1.0f);
	R = Math::IntAsFloat(0x78000000);
.
