/////////////////////////////////////////////////////////////////////////////
// Animated height field node
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
// Contstructor
/////////////////////////////////////////////////////////////////////////////
inline AHFNode::AHFNode(void)
{
	// We can refer to several points
	for (int assoc = 0; assoc < AHFNODE_MAXASSOC; assoc++)
	{
		point[assoc] = NULL;
		normal[assoc] = NULL;
		color[assoc] = NULL;

		for (int index = 0; index < ANIHF_MAXTEXTURES; index++)
			uv[assoc][index] = NULL;
	}

	// Clear our flags
	flags = 0;
}

/////////////////////////////////////////////////////////////////////////////
// Are we visible?
/////////////////////////////////////////////////////////////////////////////
inline bool AHFNode::Shadowed(void)
{
	return((flags & SHADOWED) != 0);
}

/////////////////////////////////////////////////////////////////////////////
// Are we locked?
/////////////////////////////////////////////////////////////////////////////
inline bool AHFNode::Locked(void)
{
	return((flags & LOCKED) != 0);
}

/////////////////////////////////////////////////////////////////////////////
// Set our normal
/////////////////////////////////////////////////////////////////////////////
inline void AHFNode::SetNormal(
Vector3CRef n)
{
	for (int i = 0; i < AHFNODE_MAXASSOC; i++)
	{
		if (normal[i])
			*normal[i] = n;
	}
}

/////////////////////////////////////////////////////////////////////////////
// Get the normal
/////////////////////////////////////////////////////////////////////////////
inline Vector3Packed *AHFNode::GetNormal(void)
{
	return(normal[0]);
}

/////////////////////////////////////////////////////////////////////////////
// Set a color based on the normal
/////////////////////////////////////////////////////////////////////////////
inline void AHFNode::SetColorNormal(
Vector3CRef n)
{
	const Vector3 one( 1.0f, 1.0f, 1.0f );
	Vector3 normal = ((n + one ) * 0.5f ) * 255.0f;

	ts_bRGBA c;
	c.R = (u8)normal.x();
	c.G = (u8)normal.y();
	c.B = (u8)normal.z();
	c.A = 255;

	for (int i = 0; i < AHFNODE_MAXASSOC; i++)
	{
		if (color[i])
			*color[i] = c;
	}
}

/////////////////////////////////////////////////////////////////////////////
// Set a set of UV's
/////////////////////////////////////////////////////////////////////////////
inline void AHFNode::SetUV(
int uvIndex,
const UVCOORD_TYPE &setUV)
{
	// Make sure this is a supported uv pair index
	ASSERT(uvIndex >= 0 && uvIndex < ANIHF_MAXTEXTURES);

	for (int i = 0; i < AHFNODE_MAXASSOC; i++)
	{
		if (uv[i][uvIndex])
		 	*uv[i][uvIndex] = setUV;
	}
}

/////////////////////////////////////////////////////////////////////////////
// Get the point
/////////////////////////////////////////////////////////////////////////////
inline UVCOORD_TYPE *AHFNode::GetUV(
int uvIndex)
{
	return(uv[0][uvIndex]);
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
inline void AHFNode::SetFlag(
NODEFLAG flag)
{
	flags |= flag;
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
inline void AHFNode::ClearFlag(
NODEFLAG flag)
{
	flags &= ~flag;
}

/////////////////////////////////////////////////////////////////////////////
// Associate a point with this node
/////////////////////////////////////////////////////////////////////////////
inline void AHFNode::AssociatePoint(
Vector3Packed *p)
{
	// Find an open slot
	for (int i = 0; i < AHFNODE_MAXASSOC; i++)
	{
		if (!point[i])
		{
			point[i] = p;
			return;
		}
	}

	// This is bad, there are none free
	ASSERT(false);
}

/////////////////////////////////////////////////////////////////////////////
// Associate a normal with this node
/////////////////////////////////////////////////////////////////////////////
inline void AHFNode::AssociateNormal(
Vector3Packed *n)
{
	// Find an open slot
	for (int i = 0; i < AHFNODE_MAXASSOC; i++)
	{
		if (!normal[i])
		{
			normal[i] = n;
			return;
		}
	}

	// This is bad, there are none free
	ASSERT(false);
}

/////////////////////////////////////////////////////////////////////////////
// Associate a color set wiht this node
/////////////////////////////////////////////////////////////////////////////
inline void AHFNode::AssociateColor(
ts_bRGBA *c)
{
	// Find an open slot
	for (int i = 0; i < AHFNODE_MAXASSOC; i++)
	{
		if (!color[i])
		{
			color[i] = c;
			return;
		}
	}

	// This is bad, there are none free
	ASSERT(false);
}

/////////////////////////////////////////////////////////////////////////////
// Associate a UV set with this node
/////////////////////////////////////////////////////////////////////////////
inline void AHFNode::AssociateUV(
int uvIndex,
UVCOORD_TYPE *uvPair)
{
	// Make sure this is a supported uv pair index
	ASSERT(uvIndex >= 0 && uvIndex < ANIHF_MAXTEXTURES);

	// Find an open slot
	for (int i = 0; i < AHFNODE_MAXASSOC; i++)
	{
		if (!uv[i][uvIndex])
		{
			uv[i][uvIndex] = uvPair;
			return;
		}
	}

	// This is bad, there are none free
	ASSERT(false);
}

