///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
#include "Effects/EffectsPCH.h"

#include "Display/Common/TextureAnimatorArray.h"
#include "Effects/damageanim.h"

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
DamageAnimator::DamageAnimator()
{
	m_instance = NULL;
	m_stage = -1;
	SetUVScale(1.0f, 1.0f);
	SetUVScale(0, 0.0f, 0.0f);
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
void DamageAnimator::SetInstance(
CInstance &instance)
{
	m_instance = &instance;
	m_stage = -1;
	Update(0);
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
void DamageAnimator::SetUVScale(
float uScale, float vScale)
{
	for (int i = 0; i < MAX_DAMAGEANIM_STAGES; i++)
		m_uvScale[i].Set(uScale, vScale);
}
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
void DamageAnimator::SetUVScale(int stage, float uScale, float vScale)
{
	if (stage >= 0 && stage < MAX_DAMAGEANIM_STAGES)
		m_uvScale[stage].Set(uScale, vScale);
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
void DamageAnimator::SetStage(int stage)
{
	// In range, hit it!
	ASSERT(stage >= 0);
	Update(stage);
}

///////////////////////////////////////////////////////////////////////////////
// Reset the state
///////////////////////////////////////////////////////////////////////////////
void DamageAnimator::Reset()
{
	m_stage = -2;
	Update(0);
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
void DamageAnimator::Update(
int wantStage)
{
	// Quick exit
	if (wantStage == m_stage)
		return;

	int animators = TextureAnimators();
	for (int a = 0; a < animators; a++)
	{
		// Does this object have animations?
		TextureAnimator *animator = GetTextureAnimator(a);
		if (animator)
		{
			int stages = (int)animator->GetTextureCount();

			// Have we initialized yet?
			if (m_stage == -1)
				animator->SetFPS(0.0f);

			m_stage = wantStage;
			if (m_uvScale[m_stage].X() != 0.0f && m_uvScale[m_stage].Y() != 0.0f)
				animator->SetTextureTransformScale(m_uvScale[m_stage].X(), m_uvScale[m_stage].Y());
			animator->SetCurrentFrame(Math::Min(m_stage, stages - 1));
		}
	}
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
inline int DamageAnimator::TextureAnimators()
{
	if (m_instance && m_instance->GetTextureAnimatorArray())
		return m_instance->GetTextureAnimatorArray()->Count();
	else
		return 0;
}

///////////////////////////////////////////////////////////////////////////////
// Animation support
///////////////////////////////////////////////////////////////////////////////
inline TextureAnimator *DamageAnimator::GetTextureAnimator(int index)
{
	ASSERT(index >= 0);

	if (!m_instance)
		return NULL;

	TextureAnimatorArray *animatorArray = m_instance->GetTextureAnimatorArray();
	if (!animatorArray || index >= animatorArray->Count())
		return NULL;

	return animatorArray->Get(index);
}
