///////////////////////////////////////////////////////////////////////////////
// Decal implementations
///////////////////////////////////////////////////////////////////////////////
#include "Effects/EffectsPCH.h"

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
TTLDecalEmitter::TTLDecalEmitter(
DecalSet &set,
const DecalTextureLayer *layer,
int layers,
float ttl) :
AutomaticDecalEmitter<TTLDecal>(set, layer, layers),
m_ttl(ttl)
{
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
void TTLDecalEmitter::OnCreate(
int decal,
Vector3CRef point,
Vector3CRef normal,
Vector3CRef up,
float halfWidth,
float halfHeight,
float heightTweak,
ts_bRGBA color[4],
Vector2 uv[4])
{
	// Setup the death
	if (Math::Zero(m_ttl))
		m_decalList[decal].death = 0.0f;
	else
		m_decalList[decal].death = g_timer.GetEndSec() + m_ttl;
}

///////////////////////////////////////////////////////////////////////////////
// Our update
///////////////////////////////////////////////////////////////////////////////
void TTLDecalEmitter::Update(
const CInstance &instance,
const Graphics4x4 &localToCamera,
float zCamDist)
{
	// Has anyone expired?
	float now = g_timer.GetEndSec();

	// Scan the instances for dead ones
	while (m_decals > 0 && Dead(now, m_decalList[m_tail]))
		FreeDecal();
}

