///////////////////////////////////////////////////////////////////////////////
// Static decals require a handle and must be deleted.
///////////////////////////////////////////////////////////////////////////////
#include "Effects/EffectsPCH.h"

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
BornOnDecalEmitter::BornOnDecalEmitter(
DecalSet &set,
const DecalTextureLayer *layer,
int layers) :
StaticDecalEmitter<DecalBorn>(set, layer, layers)
{
}


///////////////////////////////////////////////////////////////////////////////
// What is the born on date for this thingie?
///////////////////////////////////////////////////////////////////////////////
float BornOnDecalEmitter::BornOn(
StaticDecalHandle handle)
{
	int index = HandleToIndex(handle);
	if (index < 0)
		return -1.0f;
	else
		return m_decalList[index].extra.timeBorn;
}

///////////////////////////////////////////////////////////////////////////////
// You write this, it gets called on successful create
///////////////////////////////////////////////////////////////////////////////
void BornOnDecalEmitter::OnCreate(
int index,
PerDecal &decal)
{
	decal.extra.timeBorn = g_timer.GetEndSec();
}
