/////////////////////////////////////////////////////////////////////////////
// Fast 1d table noise lookup
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
// Get (index [0, 1]
/////////////////////////////////////////////////////////////////////////////
inline float FastNoise::Get(
float t)
{
	ASSERT(lookup);

	int index = (int)(Math::Frac(t) * tConv + 0.5f);
	return(lookup[index]);
}

/////////////////////////////////////////////////////////////////////////////
// Get smoothed index [0, 1]
/////////////////////////////////////////////////////////////////////////////
inline float FastNoise::GetSmooth(
float t)
{
	ASSERT(lookup);

	float it = Math::Frac(t) * tConv;
	float t0 = Math::Floor(it);
	float t1 = Math::Floor(it + 1.0f);
	float n0 = lookup[(int)t0];
	float n1 = lookup[(int)t1];

	return(n0 + (n1 - n0) * (it - t0));
}
