/////////////////////////////////////////////////////////////////////////////
// Simple (but true 3d) leaf effect
/////////////////////////////////////////////////////////////////////////////

#include <stdlib.h>
#include "Math/fastrand.h"
#include "path/SplinePath.h"

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
inline void LeafBlower::UpdateAffector(
Affector &a)
{
	a.speedSquared = a.actor->GetVelocityInWorld().LengthSquared();
	a.dir = a.actor->GetBodyToWorld().GetRow2();
	a.right = a.actor->GetBodyToWorld().GetRow0();
	a.speedRatio = Math::Min(Math::Sqrt(a.speedSquared * a.invMaxSpeedSquared), 1.0f);
	if (a.path)
		a.pathD = Math::Max(a.path->NearestDistance(a.actor->GetBodyInWorld()), 0.0f);
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
inline void LeafBlower::ShowLeaf(
LeafData &leaf,
bool show)
{
	leaf.instance.Hide( !show );
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
inline bool LeafBlower::LeafHidden(
LeafData &leaf)
{
	return leaf.instance.Hidden();
}

/////////////////////////////////////////////////////////////////////////////
// Add a leaf to the scene
/////////////////////////////////////////////////////////////////////////////
inline void LeafBlower::AddToScene(
LeafData &leaf)
{
	SceneMgr::AddInstance(&leaf.instance);
}

/////////////////////////////////////////////////////////////////////////////
// Remove the leaf from the scene
/////////////////////////////////////////////////////////////////////////////
inline void LeafBlower::RemoveFromScene(
LeafData &leaf)
{
	SceneMgr::RemoveInstance(&leaf.instance);
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
inline bool LeafBlower::LeafVisible(
LeafData &leaf,
float cullDistanceSquared,
Vector3CRef cameraPos,
Vector3CRef cameraDir,
Vector3 &cameraToLeaf)
{
	// Make the diff vector
	cameraToLeaf = leaf.leaf.Position() - cameraPos;

	// If it's in front of the camera, it is always visible
	float dot = Vector3::Dot(cameraToLeaf, cameraDir);
	if (dot > 0.0f)
		return(true);
	else
	{
		// Behind the camera, let it live for a bit
		float d = cameraToLeaf.LengthSquared();
		return(d < cullDistanceSquared);
	}
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
inline bool LeafBlower::LeafVisiblePath(
LeafData &leaf,
LeafFollow &follow,
Vector3CRef cameraPos,
Vector3 &cameraToLeaf)
{
	// Make the diff vector
	cameraToLeaf = leaf.leaf.Position() - cameraPos;

	// We don't care too much about anything, other than how far behind us
	// it's gotten
	return(follow.affector.pathD - leaf.leaf.GetD() < follow.distributeLength * 0.4f);
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
inline void LeafBlower::AdjustLeafAlpha(
LeafData &leaf,
Vector3CRef cameraToLeaf)
{
	float d = cameraToLeaf.LengthSquared();
	leaf.instance.SetAlpha( Math::Clamp(1.0f - (d - maxAlphaD) * invAlphaRange) );
}

/////////////////////////////////////////////////////////////////////////////
// return a random -1 or 1 (hopefully quickly)
/////////////////////////////////////////////////////////////////////////////
inline float LeafBlower::RandSign(void)
{
	if (rand() & 0x10)
		return(1.0);
	else
		return(-1.0f);
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
inline Vector3 LeafBlower::RandUnitVector(void)
{
	Vector3 v;

	v.Set(g_random.NegPos(),
			g_random.NegPos(),
			g_random.NegPos());
	v.Normalize();

	return(v);
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
inline Vector3 LeafBlower::RandUnitVectorXZ(void)
{
	Vector3 v;

	v.Set(g_random.NegPos(),
			0.0f,
			g_random.NegPos());
	v.Normalize();

	return(v);
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
inline float LeafBlower::Square(float f)
{
	return(f * f);
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
inline float LeafBlower::Cube(float f)
{
	return(f * f * f);
}
