#include <stdlib.h>

/////////////////////////////////////////////////////////////////////////////
// Initialization inlines
/////////////////////////////////////////////////////////////////////////////
inline float PerlinNoise::RandomKernel(void)
{
	return((float)((rand() % (PERLIN_KERNEL + PERLIN_KERNEL)) - PERLIN_KERNEL)
						/ PERLIN_KERNEL);
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
inline Vector2 PerlinNoise::RandomKernel2(void)
{
	Vector2 temp;

	temp.x( RandomKernel());
	temp.y( RandomKernel());
	temp.Normalize();

	return(temp);
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
inline Vector3 PerlinNoise::RandomKernel3(void)
{
	Vector3 temp;

	temp.x( RandomKernel());
	temp.y( RandomKernel());
	temp.z( RandomKernel());
	temp.SafeNormalize();

	return(temp);
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
inline void PerlinNoise::Swap(
int &a,
int &b)
{
	int temp = a;
	a = b;
	b = temp;
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
inline void PerlinNoise::SetupInterpolators(
float t,
int &b0,
int &b1,
float &r0,
float &r1)
{
	t += (float)PERLIN_BASE_SCALE;
	b0 = ((int)t) & PERLIN_KERNEL_MASK;
	b1 = (b0 + 1) & PERLIN_KERNEL_MASK;
	r0 = t - (int)t;
	r1 = r0 - 1.0f;
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
inline float PerlinNoise::Dot(
const Vector2 &g,
float rx,
float ry)
{
	return(rx * g.x() + ry * g.y());
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
inline float PerlinNoise::Dot(
Vector3CRef g,
float rx,
float ry,
float rz)
{
	return(rx * g.x() + ry * g.y() + rz * g.z());
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
inline float PerlinNoise::SCurve(float t)
{
	return(t * t * (3.0f - 2.0f * t));
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
inline float PerlinNoise::Lerp(float t, float a, float b)
{
	return(a + t * (b - a));
}

