/////////////////////////////////////////////////////////////////////////////
// Simple signal generator class
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
inline SigGen::SigGen(void)
{
	type = NONE;
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
inline SigGen::SigGen(
TYPE type,
float freq,
float amp)
{
	Setup(type, freq, amp);
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
inline SigGen::~SigGen(void)
{
}

/////////////////////////////////////////////////////////////////////////////
// Setup
/////////////////////////////////////////////////////////////////////////////
inline void SigGen::Setup(
TYPE type,
float freq,
float amp)
{
	// Handy check
	if (freq == 0.0f || amp == 0.0f)
		type = NONE;

	// Setup everything
	this->type = type;
	this->freq = freq;
	this->amp = amp;

	// do we need the noise generator?
	if (this->type == FASTNOISE || 
			this->type == FASTSMOOTHNOISE)
		fastNoise.Setup(freq);
}

/////////////////////////////////////////////////////////////////////////////
// Are we ready?
/////////////////////////////////////////////////////////////////////////////
inline bool SigGen::Ready(void)
{
	return(type != NONE);
}

/////////////////////////////////////////////////////////////////////////////
// Generate values
/////////////////////////////////////////////////////////////////////////////
inline float SigGen::Generate(
float t,
float omega)
{
	switch (type)
	{
		case SIN:
			return(amp * Math::Sin(t * freq + omega));

		case COS:
			return(amp * Math::Cos(t * freq + omega));

		case NOISE:
			return(amp * noise.LoopNoise(Math::Mod(t * freq + omega, freq), freq));

		case FASTNOISE:
			return(amp * fastNoise.Get(t + omega));

		case FASTSMOOTHNOISE:
			return(amp * fastNoise.GetSmooth(t + omega));
	}

	// no type specified
	return(0.0f);
}

