/////////////////////////////////////////////////////////////////////////////
// Inlines for the rigid body class
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
inline void RigidBodyState::ToGraphics4x4(
Graphics4x4 &m)
{
	m.Compose(orientation, pos);
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
inline void RigidBodyState::FromGraphics4x4(
const Graphics4x4 &m)
{
	m.Decompose(orientation, pos);
}

/////////////////////////////////////////////////////////////////////////////
// Get the velocity of a point on the body
/////////////////////////////////////////////////////////////////////////////
inline Vector3 RigidBody::PointVelocity(
Vector3CRef p)
{
	Vector3 d = p - state.pos;
	if (Math::Zero(d.LengthSquared()))
		return(state.velocity);
	else
		return(state.velocity + Vector3::Cross(state.angularVelocity, d));
}


