/////////////////////////////////////////////////////////////////////////////
// Screen Space Effect Manger class
//
// Manages a list of screen space effects
/////////////////////////////////////////////////////////////////////////////
#include "Effects/EffectsPCH.h"

// Our singleton
SSEffectsMgr *g_ssEffectsPtr = NULL;

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
SSEffectsMgr::SSEffectsMgr(void) :
list(false)
{
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
SSEffectsMgr::~SSEffectsMgr(void)
{
}

/////////////////////////////////////////////////////////////////////////////
// Initialize/terminate the system
/////////////////////////////////////////////////////////////////////////////
void SSEffectsMgr::Initialize()
{
	ASSERT(!g_ssEffectsPtr);
	g_ssEffectsPtr = new SSEffectsMgr;
	ASSERT(g_ssEffectsPtr != NULL);
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
void SSEffectsMgr::Terminate()
{
	if (g_ssEffectsPtr)
	{
		ASSERT(g_ssEffectsPtr->list.Head() == NULL);
		delete g_ssEffectsPtr;
		g_ssEffectsPtr = NULL;
	}
}

/////////////////////////////////////////////////////////////////////////////
// Add an effect to the start of the list
/////////////////////////////////////////////////////////////////////////////
bool SSEffectsMgr::AddHead(
ScreenSpaceEffect *effect)
{
	if (!effect)
		return(false);

	list.AddHead(effect);
	return(true);
}

/////////////////////////////////////////////////////////////////////////////
// Add an effect to the end of the list
/////////////////////////////////////////////////////////////////////////////
bool SSEffectsMgr::AddTail(
ScreenSpaceEffect *effect)
{
	if (!effect)
		return(false);

	list.AddTail(effect);
	return(true);
}

/////////////////////////////////////////////////////////////////////////////
// Remove the effect from the list (doesn't delete it)
/////////////////////////////////////////////////////////////////////////////
bool SSEffectsMgr::Remove(
ScreenSpaceEffect *effect)
{
	if (!effect)
		return(false);

	list.Unlink(effect);
	return(true);
}

/////////////////////////////////////////////////////////////////////////////
// Call all of the updates
/////////////////////////////////////////////////////////////////////////////
void SSEffectsMgr::Update(
CameraScene *scene)
{
	ScreenSpaceEffect *effect = list.Head();
	while (effect)
	{
		effect->Update(scene);
		effect = effect->next;
	}
}

