/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
#include "Math/fastrand.h"

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
inline void WidgetFactory::ShowWidget(
Widget &widget,
bool show)
{
	widget.instance.Hide( !show );
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
inline bool WidgetFactory::WidgetHidden(
Widget &widget)
{
	return widget.instance.Hidden();
}

/////////////////////////////////////////////////////////////////////////////
// Add a widget to the scene
/////////////////////////////////////////////////////////////////////////////
inline void WidgetFactory::AddToScene(
Widget &widget)
{
	SceneMgr::AddInstance(&widget.instance);
	SceneMgr::SetInstanceVisRegionStatic(&widget.instance,true);
}

/////////////////////////////////////////////////////////////////////////////
// Remove the widget from the scene
/////////////////////////////////////////////////////////////////////////////
inline void WidgetFactory::RemoveFromScene(
Widget &widget)
{
	SceneMgr::RemoveInstance(&widget.instance);
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
inline void WidgetFactory::SetAlpha(
Widget &widget,
float alpha)
{
	widget.instance.SetAlpha( alpha );
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
inline void WidgetFactory::ResetAlpha(
Widget &widget)
{
	widget.instance.SetAlpha( 1.0f );
}