/////////////////////////////////////////////////////////////////////////////
// Really simple class to compute CRC's
/////////////////////////////////////////////////////////////////////////////
#include "EngineHelper/EngineHelperPCH.h"
#include "EngineHelper/crc.h"

// define static member
CRCLookupTable CRCCompute::_table;

/////////////////////////////////////////////////////////////////////////////
// Simple function that does it all!
/////////////////////////////////////////////////////////////////////////////
CRCValue ComputeCRC(
void *data,
unsigned int dataLength)
{
	CRCCompute crc;
	crc.PutString((unsigned char *)data, dataLength);
	return crc.Done();
}

/////////////////////////////////////////////////////////////////////////////
// Initialize with a key
/////////////////////////////////////////////////////////////////////////////
CRCCompute::CRCCompute(CRCValue key) :
_key(key),
_register(0)
{
	_table.Init(key);
}

/////////////////////////////////////////////////////////////////////////////
// Add data into the computation
/////////////////////////////////////////////////////////////////////////////
void CRCCompute::PutByte(unsigned char byte)
{
	CRCValue top = (_register >> 24);
	top ^= (CRCValue)byte;
	_register = ((_register << 8) ^ _table[top]);
}

/////////////////////////////////////////////////////////////////////////////
// Add data into the computation
/////////////////////////////////////////////////////////////////////////////
void CRCCompute::PutString(
unsigned char *string,
unsigned int length)
{
	for (unsigned int i = 0; i < length; i++)
		PutByte(string[i]);
}

/////////////////////////////////////////////////////////////////////////////
// Call to get CRC value and reset
/////////////////////////////////////////////////////////////////////////////
CRCValue CRCCompute::Done(void)
{
	CRCValue temp = _register;
	_register = 0;
	return temp;
}

/////////////////////////////////////////////////////////////////////////////
// The lookup table
/////////////////////////////////////////////////////////////////////////////
void CRCLookupTable::Init(CRCValue key)
{
	if (key == _key)
		return;
	_key = key;

	// for all possible byte values
	for (unsigned	int i = 0; i < 256; i++)
	{
		CRCValue reg = (i << 24);

		// for all bits in a byte
		for (int j = 0; j < 8; ++j)
		{
			bool topBit = ((reg & 0x80000000) != 0);
			reg = (reg << 1);
			if (topBit)
				reg ^= _key;
		}

		_table [i] = reg;
	}
}


