/////////////////////////////////////////////////////////////////////////////
// Simple (but true 3d) objects
/////////////////////////////////////////////////////////////////////////////
#include "EngineHelper/EngineHelperPCH.h"

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
SimpleInstance::SimpleInstance()
{
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
SimpleInstance::~SimpleInstance()
{
	Destroy();
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
bool SimpleInstance::Create(
const char *pathFile,
int flags)
{
	// Are they dumb?
	ASSERT(pathFile);

	// First make sure we can even load this model
	ts_Geometry* geometry = g_loadSOM.Geometry(pathFile);
	if (!geometry)
		return false;

	// Build up the instance stuff
	m_instance.InitFromGeometry( *geometry );
	m_instance.SetName( "simpleInst" );
	m_instance.Matrix().Identity();

	// instance flags
	m_instance.SetReceiveShadows( false );
	m_instance.SetDynamicallyLit( ( flags & DYNAMIC_LIGHT ) != 0 );
	m_instance.SetAlphaSort( ( flags & ALPHA_SORT ) != 0 );
	m_instance.SetZWriteDisabled( ( flags & NO_ZWRITE ) != 0 );
	m_instance.SetAdditiveBlend( ( flags & ADDITIVE_BLEND ) != 0 );

	// duh
	m_instance.UpdateBoundingVolumes();

	// Add them all to the scene
	return AddToScene();
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
void SimpleInstance::Destroy()
{
	SceneMgr::RemoveInstance(&m_instance);
	m_instance.Destroy();
}

/////////////////////////////////////////////////////////////////////////////
// Show hide this instance
/////////////////////////////////////////////////////////////////////////////
void SimpleInstance::Show(bool show)
{
	m_instance.Hide( !show );
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
bool SimpleInstance::Hidden()
{
	return m_instance.Hidden();
}

/////////////////////////////////////////////////////////////////////////////
// Place the instnace
/////////////////////////////////////////////////////////////////////////////
void SimpleInstance::Place(
const Graphics4x4 &place)
{
	m_instance.Matrix() = place;
	m_instance.UpdateBoundingVolumes();
}

/////////////////////////////////////////////////////////////////////////////
// Add and remove widgets from the scene
/////////////////////////////////////////////////////////////////////////////
bool SimpleInstance::AddToScene()
{
	return SceneMgr::AddInstance(&m_instance);
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
void SimpleInstance::RemoveFromScene()
{
	SceneMgr::RemoveInstance(&m_instance);
}

