///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
#include "Environ/EnvironPCH.h"
#include "Environ/Munition.h"
#include "CollideHelper/LineQuery.h"

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
CMunitionImpact::CMunitionImpact()
{
	d_victim = NULL;
}

///////////////////////////////////////////////////////////////////////////////
// Set from a collision
///////////////////////////////////////////////////////////////////////////////
void CMunitionImpactSurface::SetQuery(
const CLineQuery &hit)
{
	d_victim = hit.actor;
	d_intersection = hit.intersection;
	d_surfaceNormal = hit.normal;
	d_surfaceMaterial = hit.material;

	int r = ((hit.color >> 0) & 0x1f) << 3;
	int g = ((hit.color >> 5) & 0x3f) << 2;
	int b = ((hit.color >> 11) & 0x1f) << 3;
	d_surfaceShade = Math::Clamp((r + g + b) / 3, 0, 255);
}
