/////////////////////////////////////////////////////////////////////////////
// Display height field node
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
// Contstructor
/////////////////////////////////////////////////////////////////////////////
inline DHFNode::DHFNode(void)
{
	// We can refer to several points
	for (int assoc = 0; assoc < DHFNODE_MAXASSOC; assoc++)
	{
		point[assoc] = NULL;
		normal[assoc] = NULL;
		color[assoc] = NULL;

		for (int index = 0; index < DISPHF_MAXTEXTURES; index++)
			uv[assoc][index] = NULL;
	}
}

/////////////////////////////////////////////////////////////////////////////
// Set out point in space
/////////////////////////////////////////////////////////////////////////////
inline void DHFNode::SetPoint(
Vector3CRef p)
{
	for (int i = 0; i < DHFNODE_MAXASSOC; i++)
	{
		if (point[i])
			*point[i] = p;
	}
}

/////////////////////////////////////////////////////////////////////////////
// Get the point
/////////////////////////////////////////////////////////////////////////////
inline Vector3 *DHFNode::GetPoint(void)
{
	return(point[0]);
}

/////////////////////////////////////////////////////////////////////////////
// Set our normal
/////////////////////////////////////////////////////////////////////////////
inline void DHFNode::SetNormal(
Vector3CRef n)
{
	for (int i = 0; i < DHFNODE_MAXASSOC; i++)
	{
		if (normal[i])
			*normal[i] = n;
	}
}

/////////////////////////////////////////////////////////////////////////////
// Get the normal
/////////////////////////////////////////////////////////////////////////////
inline Vector3 *DHFNode::GetNormal(void)
{
	return(normal[0]);
}

/////////////////////////////////////////////////////////////////////////////
// Set a color
/////////////////////////////////////////////////////////////////////////////
inline void DHFNode::SetColor(
const ts_bRGBA &c)
{
	for (int i = 0; i < DHFNODE_MAXASSOC; i++)
	{
		if (color[i])
			*color[i] = c;
	}
}

/////////////////////////////////////////////////////////////////////////////
// Set a set of UV's
/////////////////////////////////////////////////////////////////////////////
inline void DHFNode::SetUV(
int uvIndex,
const UVCOORD &setUV)
{
	// Make sure this is a supported uv pair index
	ASSERT(uvIndex >= 0 && uvIndex < DISPHF_MAXTEXTURES);

	for (int i = 0; i < DHFNODE_MAXASSOC; i++)
	{
		if (uv[i][uvIndex])
		 	*uv[i][uvIndex] = setUV;
	}
}

/////////////////////////////////////////////////////////////////////////////
// Get the point
/////////////////////////////////////////////////////////////////////////////
inline UVCOORD *DHFNode::GetUV(
int uvIndex)
{
	return(uv[0][uvIndex]);
}

/////////////////////////////////////////////////////////////////////////////
// Associate a point with this node
/////////////////////////////////////////////////////////////////////////////
inline void DHFNode::AssociatePoint(
Vector3 *p)
{
	// Find an open slot
	for (int i = 0; i < DHFNODE_MAXASSOC; i++)
	{
		if (!point[i])
		{
			point[i] = p;
			return;
		}
	}

	// This is bad, there are none free
	ASSERT(false);
}

/////////////////////////////////////////////////////////////////////////////
// Associate a normal with this node
/////////////////////////////////////////////////////////////////////////////
inline void DHFNode::AssociateNormal(
Vector3 *n)
{
	// Find an open slot
	for (int i = 0; i < DHFNODE_MAXASSOC; i++)
	{
		if (!normal[i])
		{
			normal[i] = n;
			return;
		}
	}

	// This is bad, there are none free
	ASSERT(false);
}

/////////////////////////////////////////////////////////////////////////////
// Associate a color set wiht this node
/////////////////////////////////////////////////////////////////////////////
inline void DHFNode::AssociateColor(
ts_bRGBA *c)
{
	// Find an open slot
	for (int i = 0; i < DHFNODE_MAXASSOC; i++)
	{
		if (!color[i])
		{
			color[i] = c;
			return;
		}
	}

	// This is bad, there are none free
	ASSERT(false);
}

/////////////////////////////////////////////////////////////////////////////
// Associate a UV set with this node
/////////////////////////////////////////////////////////////////////////////
inline void DHFNode::AssociateUV(
int uvIndex,
UVCOORD *uvPair)
{
	// Make sure this is a supported uv pair index
	ASSERT(uvIndex >= 0 && uvIndex < DISPHF_MAXTEXTURES);

	// Find an open slot
	for (int i = 0; i < DHFNODE_MAXASSOC; i++)
	{
		if (!uv[i][uvIndex])
		{
			uv[i][uvIndex] = uvPair;
			return;
		}
	}

	// This is bad, there are none free
	ASSERT(false);
}

