#ifndef _INCLUDED_OSI_PLAYER_STATS_
#define _INCLUDED_OSI_PLAYER_STATS_

#include <Time.h>
#include "OSIPlayerID.hpp"
#include "OSIClans.hpp"

class OSIPlayerStats
{
public:

	enum PlayerStatIndex
	{
		INVALID_PLAYERSTAT = -1,
		
		// Arbitrated stats
		PLAYERSTAT_USER_RATING,
		PLAYERSTAT_COP_RATING,
		PLAYERSTAT_GANG_RATING,
		PLAYERSTAT_COP_WINS,
		PLAYERSTAT_COP_GAMES_PLAYED,
		PLAYERSTAT_COP_PLAYERS_IN_ROUND,
		PLAYERSTAT_GANG_WINS,
		PLAYERSTAT_GANG_GAMES_PLAYED,
		PLAYERSTAT_GANG_PLAYERS_IN_ROUND,
		PLAYERSTAT_KILLS_AS_COP,
		PLAYERSTAT_DEATHS_AS_COP,
		PLAYERSTAT_KILLS_AS_GANGSTA,
		PLAYERSTAT_DEATHS_AS_GANGSTA,
		PLAYERSTAT_COP_MVPS,
		PLAYERSTAT_GANG_MVPS,
		
		LAST_ARBITRATED_STAT = PLAYERSTAT_GANG_MVPS,
		FIRST_NONARBITRATED_STAT,

		// Start of non-arbitrated stats
		PLAYERSTAT_NA_RANK = FIRST_NONARBITRATED_STAT,
		PLAYERSTAT_NA_COP_WINS,
		PLAYERSTAT_NA_COP_LOSSES,
		PLAYERSTAT_NA_COP_TIES,
		PLAYERSTAT_NA_GANG_WINS,
		PLAYERSTAT_NA_GANG_LOSSES,
		PLAYERSTAT_NA_GANG_TIES,
		PLAYERSTAT_NA_COP_KILLS,
		PLAYERSTAT_NA_GANG_KILLS,
		PLAYERSTAT_NA_COP_DEATHS,
		PLAYERSTAT_NA_GANG_DEATHS,
		PLAYERSTAT_NA_COP_SUICIDES,
		PLAYERSTAT_NA_GANG_SUICIDES,
		PLAYERSTAT_NA_COP_HEADSHOTS,
		PLAYERSTAT_NA_GANG_HEADSHOTS,
		PLAYERSTAT_NA_COP_TEAM_KILLS,
		PLAYERSTAT_NA_GANG_TEAM_KILLS,
		PLAYERSTAT_NA_COP_TEAM_DEATHS,
		PLAYERSTAT_NA_GANG_TEAM_DEATHS,
		PLAYERSTAT_NA_COP_NPC_KILLS,
		PLAYERSTAT_NA_GANG_NPC_KILLS,
		PLAYERSTAT_NA_APPREHENSIONS,
		PLAYERSTAT_NA_APPREHENDED,
		PLAYERSTAT_NA_COP_SHOTS_FIRED,
		PLAYERSTAT_NA_GANG_SHOTS_FIRED,
		PLAYERSTAT_NA_COP_SHOTS_HIT,
		PLAYERSTAT_NA_GANG_SHOTS_HIT,
		PLAYERSTAT_NA_COP_TIME_PLAYED,
		PLAYERSTAT_NA_GANG_TIME_PLAYED,
		PLAYERSTAT_NA_LOOT_SCORES,
		PLAYERSTAT_NA_RAID_SCORES,
		PLAYERSTAT_NA_TAG_SCORES,
		PLAYERSTAT_NA_COP_MELEE,
		PLAYERSTAT_NA_COP_GRENADE,
		PLAYERSTAT_NA_COP_SPECIAL,
		PLAYERSTAT_NA_COP_SUB_MACHINEGUN,
		PLAYERSTAT_NA_COP_HEAVY_MACHINEGUN,
		PLAYERSTAT_NA_COP_SHOTGUN,
		PLAYERSTAT_NA_GANG_MELEE,
		PLAYERSTAT_NA_GANG_GRENADE,
		PLAYERSTAT_NA_GANG_SPECIAL,
		PLAYERSTAT_NA_GANG_SUB_MACHINEGUN,
		PLAYERSTAT_NA_GANG_HEAVY_MACHINEGUN,
		PLAYERSTAT_NA_GANG_SHOTGUN,
		PLAYERSTAT_NA_COP_DEATH_HOLDING_MELEE,
		PLAYERSTAT_NA_COP_DEATH_HOLDING_GRENADE,
		PLAYERSTAT_NA_COP_DEATH_HOLDING_SPECIAL,
		PLAYERSTAT_NA_COP_DEATH_HOLDING_SUB_MACHINEGUN,
		PLAYERSTAT_NA_COP_DEATH_HOLDING_HEAVY_MACHINEGUN,
		PLAYERSTAT_NA_COP_DEATH_HOLDING_SHOTGUN,
		PLAYERSTAT_NA_GANG_DEATH_HOLDING_MELEE,
		PLAYERSTAT_NA_GANG_DEATH_HOLDING_GRENADE,
		PLAYERSTAT_NA_GANG_DEATH_HOLDING_SPECIAL,
		PLAYERSTAT_NA_GANG_DEATH_HOLDING_SUB_MACHINEGUN,
		PLAYERSTAT_NA_GANG_DEATH_HOLDING_HEAVY_MACHINEGUN,
		PLAYERSTAT_NA_GANG_DEATH_HOLDING_SHOTGUN,
		PLAYERSTAT_NA_COP_DEATH_BY_MELEE,
		PLAYERSTAT_NA_COP_DEATH_BY_GRENADE,
		PLAYERSTAT_NA_COP_DEATH_BY_SPECIAL,
		PLAYERSTAT_NA_COP_DEATH_BY_SUB_MACHINEGUN,
		PLAYERSTAT_NA_COP_DEATH_BY_HEAVY_MACHINEGUN,
		PLAYERSTAT_NA_COP_DEATH_BY_SHOTGUN,
		PLAYERSTAT_NA_GANG_DEATH_BY_MELEE,
		PLAYERSTAT_NA_GANG_DEATH_BY_GRENADE,
		PLAYERSTAT_NA_GANG_DEATH_BY_SPECIAL,
		PLAYERSTAT_NA_GANG_DEATH_BY_SUB_MACHINEGUN,
		PLAYERSTAT_NA_GANG_DEATH_BY_HEAVY_MACHINEGUN,
		PLAYERSTAT_NA_GANG_DEATH_BY_SHOTGUN,
		PLAYERSTAT_NA_TAG_WINS,
		PLAYERSTAT_NA_TAG_GAMES_PLAYED,
		PLAYERSTAT_NA_TAG_TIME,
		PLAYERSTAT_NA_WAR_WINS,
		PLAYERSTAT_NA_WAR_GAMES_PLAYED,
		PLAYERSTAT_NA_WAR_TIME,
		PLAYERSTAT_NA_ROBBERY_WINS,
		PLAYERSTAT_NA_ROBBERY_GAMES_PLAYED,
		PLAYERSTAT_NA_ROBBERY_TIME,
		PLAYERSTAT_NA_RAID_WINS,
		PLAYERSTAT_NA_RAID_GAMES_PLAYED,
		PLAYERSTAT_NA_RAID_TIME,
		PLAYERSTAT_NA_MODE5_WINS,
		PLAYERSTAT_NA_MODE5_GAMES_PLAYED,
		PLAYERSTAT_NA_MODE5_TIME,
		PLAYERSTAT_NA_MODE6_WINS,
		PLAYERSTAT_NA_MODE6_GAMES_PLAYED,
		PLAYERSTAT_NA_MODE6_TIME,
		PLAYERSTAT_NA_INCOMPLETES,

		LAST_NONARBITRATED_STAT = PLAYERSTAT_NA_INCOMPLETES,
		
		NUM_PLAYERSTATS = LAST_NONARBITRATED_STAT + 1
	};

	OSIPlayerStats();

	static void*					operator new( size_t size )								{ return OSImalloc( size ); }
	static void						operator delete( void* memPtr )							{ OSIfree( memPtr ); }

	static const char * const personalStats[ NUM_PLAYERSTATS ];

	// The player with these stats
	OSIchar	name[ OSI_PLAYER_NAME_LENGTH ];
	OSIchar	clanAbbr[ OSIClanInfo::MAX_TAG_LENGTH ];
	float clanRating;
	float clanKills;
	OSIPlayerID playerID;
	float MVPScore;
	bool isCop;
	unsigned int teamID;

	// This is the main stats array, including arbitrated and non-arbitrated on the PS2.
	typedef float StatValueType;
	StatValueType statsArray[ NUM_PLAYERSTATS ];

	// Initialize all the stats to 0.
	inline void clearStats();
	inline void setStat(PlayerStatIndex statIndex, float value);
	inline void setStat(PlayerStatIndex statIndex, int value );
	inline float getStat(PlayerStatIndex statIndex) const;
};

// Clear all the stats to 0.
void OSIPlayerStats::clearStats()
{
	for ( int i = 0; i<NUM_PLAYERSTATS; i++ )
		statsArray[i] = 0;
}

void OSIPlayerStats::setStat(PlayerStatIndex statIndex, float value)
{
	statsArray[statIndex] = (StatValueType)(int)value;
}

void OSIPlayerStats::setStat(PlayerStatIndex statIndex, int value)
{
	statsArray[statIndex] = (StatValueType) value;
}

float OSIPlayerStats::getStat(PlayerStatIndex statIndex) const
{
	return statsArray[statIndex];
}

#endif // _INCLUDED_OSI_PLAYER_STATS