#ifndef _OSI_STRING_TABLE_H
#define _OSI_STRING_TABLE_H

#include "OSIchar.hpp"

extern OSIchar* OSIStringTable[];

enum OSIStringEnum
{
	//------------------------------------------------------------
	//        O S I   I N T E R N A L   S T A T E S
	//------------------------------------------------------------
	OSI_STATE_UNINITIALIAZED,                                        	
	OSI_STATE_IDLE,												 		
	OSIPS2_STATE_REQUEST_TYPE_HARDWARE_ACTIVATION,					 	
	OSIPS2_STATE_REQUEST_TYPE_ACCOUNT_LIST,							 	
	OSIPS2_STATE_REQUEST_TYPE_RENDEZVOUS_LOGIN,						 	
	OSIPS2_STATE_REQUEST_TYPE_RENDEZVOUS_HOST_MATCH,				 	
	OSIPS2_STATE_REQUEST_TYPE_RENDEZVOUS_FIND_MATCH,				 	
	OSIPS2_STATE_REQUEST_TYPE_RENDEZVOUS_SIMPLE_CALL,				 	
	OSIPS2_STATE_REQUEST_TYPE_RENDEZVOUS_FRIENDS_LIST,				 	
	OSIPS2_STATE_LOGIN_LOGGING_IN,									 	
	OSIPS2_STATE_LOGIN_DNAS_AUTHENTICATION,							    
	OSIPS2_STATE_LOGIN_CONNECTING_TO_AUTHENTICATION_SERVICE,		 	
	OSIPS2_STATE_LOGIN_REQUESTING_LOGIN,							 	
	OSIPS2_STATE_LOGIN_WAITING_FOR_LOGIN,							 	
	OSIPS2_STATE_LOGIN_CONNECTING_TO_ACCOUNT_SERVICE,				 	
	OSIPS2_STATE_LOGIN_CONNECTING_TO_FRIENDS_SERVICE,				 	
	OSIPS2_STATE_LOGIN_CONNECTING_TO_MATCHMAKING_SERVICE,			 	
	OSIPS2_STATE_LOGIN_CONNECTING_TO_COMPETITION_SERVICE,			 	
	OSIPS2_STATE_HOST_CREATE_GATHERING,								 	
	OSIPS2_STATE_HOST_REGISTER_GATHERING,							 	
	OSIPS2_STATE_HOST_WAITING_ON_GATHERING_REGISTRATION,			 	
	OSIPS2_STATE_HOST_JOIN_GATHERING,								 	
	OSIPS2_STATE_HOST_WAITING_ON_JOIN,								 	
	OSIPS2_STATE_HOST_REGISTER_LADDER_GAME,							 	
	OSIPS2_STATE_HOST_WAITING_ON_LADDER_REGISTRATION,				 	
	OSIPS2_STATE_HOST_LAUNCH_SESSION,								 	
	OSIPS2_STATE_HOST_WAITING_ON_LAUNCH,							 	
	OSIPS2_STATE_FRIENDSLIST_CONFIRMING_CONNECTED,					 	
	OSIPS2_STATE_FRIENDSLIST_REQUEST_CURRENT_FRIENDS,				 	
	OSIPS2_STATE_FRIENDSLIST_WAITING_ON_CURRENT_FRIENDS,			 	
	OSIPS2_STATE_FRIENDSLIST_REQUEST_INCOMING_OFFERS,				 	
	OSIPS2_STATE_FRIENDSLIST_WAITING_ON_INCOMING_OFFERS,			 	
	OSIPS2_STATE_FRIENDSLIST_REQUEST_OUTGOING_OFFERS,				 	
	OSIPS2_STATE_FRIENDSLIST_WAITING_ON_OUTGOING_OFFERS,			 	
	OSIPS2_STATE_FRIENDSLIST_REQUEST_UPDATE_INVITATIONS,			 	
	OSIPS2_STATE_FRIENDSLIST_WAITING_ON_UPDATE_INVITATIONS,			 	
	OSIPS2_STATE_FIND_MATCH_REQUEST_DEFAULT_QUERY,					 	
	OSIPS2_STATE_FIND_MATCH_REQUEST_CUSTOM_QUERY,					 	
	OSIPS2_STATE_FIND_MATCH_REQUEST_LADDER_QUERY,					 	
	OSIPS2_STATE_FIND_MATCH_WAITING_ON_DEFAULT_QUERY,				 	
	OSIPS2_STATE_FIND_MATCH_WAITING_ON_CUSTOM_QUERY,				 	
	OSIPS2_STATE_FIND_MATCH_WAITING_ON_LADDER_QUERY,				 	
	OSIPS2_STATE_FIND_MATCH_REQUEST_CONNECTION_INFO,				 	
	OSIPS2_STATE_FIND_MATCH_WAITING_ON_CONNECTION_INFO,				 	
	OSIPS2_STATE_BEGIN_DNAS_AUTH,									 	
	OSIPS2_STATE_JOIN_REQUEST_PARTICIPATION,						 	
	OSIPS2_STATE_JOIN_WAITING_FOR_PARTICIPATION,					 	
	OSIPS2_STATE_JOIN_REQUEST_SESSION_URL,							 	
	OSIPS2_STATE_JOIN_WAITING_FOR_SESSION_URL,						 	
	OSIPS2_STATE_JOIN_MAKE_NETZ_CONNECTION,							 	
	OSIPS2_STATE_CREATE_ACCOUNT_REQUEST_ACCOUNT_CREATION,			 	
	OSIPS2_STATE_CREATE_ACCOUNT_WAITING_FOR_ACCOUNT_CREATION,		 	
	OSIPS2_STATE_CREATE_ACCOUNT_LOGOUT,								 	
	OSIPS2_STATE_ROUND_START,										 	
	OSIPS2_STATE_ROUND_WAITING_ON_START,							 	
	OSIPS2_STATE_ROUND_CHECKING_FOR_INVITATION,						 	
	OSIPS2_STATE_ROUND_WAITING_FOR_INVITATION_CHECK,				 	
	OSIPS2_STATE_ROUND_FINISH,										 	
	OSIPS2_STATE_ROUND_WAITING_ON_FINISH,							 	
	OSIPS2_STATE_ROUND_REPORT_STATS,								 	
	OSIPS2_STATE_ROUND_WAITING_ON_REPORT_STATS,						 	
	OSIPS2_STATE_ROUND_UNREGISTER,									 	
	OSIPS2_STATE_ROUND_WAITING_ON_UNREGISTER,						 	
	OSIPS2_STATE_QUIT_MATCH_FINISH,									 	
	OSIPS2_STATE_QUIT_MATCH_FINISH_WAITING,							 	
	OSIPS2_STATE_QUIT_MATCH_UNREGISTER,								 	
	OSIPS2_STATE_QUIT_MATCH_UNREGISTER_WAITING,						 	
	OSIPS2_STATE_WAITING_ON_COMPETITION_REGISTRATION,				 	
	OSIPS2_STATE_HOST_WAITING_ON_INVITATION,						 	
	OSIPS2_STATE_INVITING_OPPONENTS,								 	
															 			
	// GENERAL ERRORS												 	
	OSIPS2_ERROR_REQUEST_ALREADY_IN_PROGRESS,						 	
																	 
	// FRIEND ERRORS												 							 	
	OSIPS2_ERROR_PLAYER_ALREADY_FRIEND,
	OSIPS2_ERROR_UNABLE_TO_AUTHORIZE_FRIENDSHIP,					 	
	OSIPS2_ERROR_UNABLE_TO_DENY_FRIENDSHIP,							 	
	OSIPS2_ERROR_UNABLE_TO_BLOCK_FRIENDSHIP,						 	
	OSIPS2_ERROR_UNABLE_TO_UNBLOCK_FRIENDSHIP,						 	
	OSIPS2_ERROR_UNABLE_TO_OFFER_FRIENDSHIP,						 	
	OSIPS2_ERROR_UNABLE_TO_CANCEL_FRIENDSHIP,						 	
	OSIPS2_ERROR_UNABLE_TO_END_FRIENDSHIP,							 	
	OSIPS2_ERROR_FRIENDS_INVITED_SELF,								 	
	OSIPS2_ERROR_FRIENDS_INVALID_NAME,								 	
	OSIPS2_ERROR_FRIENDS_YOUR_LIMIT_REACHED,						 	
	OSIPS2_ERROR_FRIENDS_THEIR_LIMIT_REACHED,						 	
																	 	
	// DNAS Errors													 	
	OSIPS2_DNAS_AUTH_SERVER_BUSY,									 	
	OSIPS2_DNAS_SOFTWARE_TITLE_NOT_IN_SERVICE,						 	
	OSIPS2_DNAS_AUTH_SERVER_NOT_IN_SERVICE,							 	
	OSIPS2_DNAS_AUTH_SERVER_TIMEOUT,								 	
	OSIPS2_DNAS_AUTH_SYSTEM_ERROR,									 	
	OSIPS2_DNAS_HARDWARE_INFO_ERROR,								 	
	OSIPS2_DNAS_DISC_INFO_ERROR,									 	
	OSIPS2_DNAS_NETWORK_CONNECTION_ABORTED,							 	
	OSIPS2_DNAS_ERROR_IN_PROXY_SETTING,								 	
	OSIPS2_DNAS_CONNECTION_TIMEOUT,									 	
	OSIPS2_DNAS_DNS_NO_RESPONSE,									 	
	OSIPS2_DNAS_DNS_RESPONSE_ERROR,									 	
	OSIPS2_DNAS_DNS_ERROR,											 	
	OSIPS2_DNAS_CONNECTION_TO_DNAS_FAILED,							 	
	OSIPS2_DNAS_CONNECTION_ERROR,									 	
	OSIPS2_DNAS_AUTH_ERROR,											 	
	OSIPS2_DNAS_UNSPECIFIED_ERROR,									 	
			 
	// Clan error mappings, these correspond with		 
	// errors returned by the Python code on the server.			 	
	// NOTE: these must stay contiguous with GENERAL first			 	
	OSIPS2_CLAN_GENERAL,												
	OSIPS2_CLAN_PERMISSION_DENIED,										
	OSIPS2_CLAN_NOT_IN_CLAN,											
	OSIPS2_CLAN_INVALID_CLAN,											
	OSIPS2_CLAN_INVALID_PLAYER,											
	OSIPS2_CLAN_CLAN_ABBR_TAKEN,										
	OSIPS2_CLAN_CLAN_NAME_TAKEN,										
	OSIPS2_CLAN_ALREADY_IN_CLAN,										
	OSIPS2_CLAN_ALREADY_INVITED,										
	OSIPS2_CLAN_NOT_ACCEPTING_INVITES,									
	OSIPS2_CLAN_INVALID_INVITATION,										
	OSIPS2_CLAN_CLAN_NOT_EMPTY,											
	OSIPS2_CLAN_CLAN_FULL,												
	OSIPS2_CLAN_CLAN_NAME_NOT_ALLOWED,									
	OSIPS2_CLAN_IN_SAME_CLAN,											
																		
	// OTHER ERRORS														
	OSIPS2_CONNECTION_FAILURE,											
	OSIPS2_COULD_NOT_AUTHENTICATE,										
	OSIPS2_INVALID_USER_NAME,											
	OSIPS2_INVALID_PASSWORD,											
	OSIPS2_USER_ALREADY_EXISTS,											
	OSIPS2_ACCOUNT_DISABLED,											
	OSIPS2_CONCURRENT_LOGIN_ERROR,										
	OSIPS2_ENCRYPTION_FAILURE,											
	OSIPS2_FILTER_ERROR,
	OSIPS2_TEXT_FILTER_ERROR,
	OSIPS2_ERROR_UNABLE_TO_INVITE_PLAYER,
	OSIPS2_ERROR_PLAYER_ALREADY_INVITED,
	OSIPS2_ERROR_JOIN_MATCH_UNABLE_TO_REQUEST_PARTICIPATION,		 	
	OSIPS2_ERROR_JOIN_MATCH_UNABLE_TO_RETRIEVE_PARTICIPATION,		 	
	OSIPS2_ERROR_JOIN_MATCH_UNABLE_TO_REQUEST_MATCH_IP,				 	
	OSIPS2_ERROR_JOIN_MATHC_UNABLE_TO_RETRIEVE_MATCH_IP,			 	
	OSIPS2_ERROR_JOIN_MATCH_UNABLE_TO_CONNECT_TO_MATCH_IP,	

	//------------------------------------------------------------------
	//      F A T A L   E R R O R S                                     
	//------------------------------------------------------------------
	OSI_BEGIN_FATAL_ERRORS,											
	OSIPS2_ERROR_FRIENDS_REQUEST_FRIENDS_LIST_FAILED,				 	
	OSIPS2_ERROR_FRIENDS_REQUEST_AUTHORIZE_FAILED,					 	
	OSIPS2_ERROR_FRIENDS_REQUEST_DENY_FAILED,						 	
	OSIPS2_ERROR_FRIENDS_REQUEST_BLOCK_FAILED,						 	
	OSIPS2_ERROR_FRIENDS_REQUEST_UNBLOCK_FAILED,					 	
	OSIPS2_ERROR_FRIENDS_REQUEST_OFFER_FAILED,						 	
	OSIPS2_ERROR_FRIENDS_REQUEST_CANCEL_OFFER_FAILED,				 	
	OSIPS2_ERROR_FRIENDS_REQUEST_END_FAILED,
	OSIPS2_ERROR_FAILED_AUTHENTICATION,								 	
	OSIPS2_ERROR_FAILED_ACTIVE_ACCOUNT,								 	
	OSIPS2_ERROR_FAILED_VERIFY_CREDENTIALS,							 	
	OSIPS2_ERROR_UNABLE_TO_CONNECT_TO_SECURE_CONNECTION_SERVICE,	 	
	OSIPS2_ERROR_UNABLE_TO_CONNECT_TO_ACCOUNT_MANAGEMENT_SERVICE,	 	
	OSIPS2_ERROR_UNABLE_TO_CONNECT_TO_FRIENDS_SERVICE,				 	
	OSIPS2_ERROR_UNABLE_TO_CONNECT_TO_MATCHMAKING_SERVICE,			 	
	OSIPS2_ERROR_UNABLE_TO_CONNECT_TO_COMPETITION_CLIENT,			 	
	OSIPS2_ERROR_UNABLE_TO_FIND_ACCOUNT,							 	
	OSIPS2_ERROR_UNABLE_TO_CREATE_CALLING_CONTEXT,					 	
	OSIPS2_ERROR_UNABLE_TO_CREATE_RENDEZVOUS,						 	
	OSIPS2_ERROR_FRIENDS_CLIENT_WAS_NOT_CONNECTED,					 	
	OSIPS2_ERROR_FAILED_TO_REGISTER_GATHERING,						 	
	OSIPS2_ERROR_FAILED_TO_PARTICIPATE_ON_JOIN,						 	
	OSIPS2_ERROR_FAILED_TO_PARTICIPATE_WAITING_ON_JOIN,				 	
	OSIPS2_ERROR_UNABLE_TO_REGISTER_COMPETITION_EVENT,				 	
	OSIPS2_ERROR_UNABLE_TO_LAUNCH_SESSION_ON_LAUNCH,				 	
	OSIPS2_ERROR_UNABLE_TO_LAUNCH_SESSION_WAITING_ON_LAUNCH,	
	OSIPS2_ERROR_UNABLE_TO_BEGIN_LAUNCHING_ROUND,
	OSIPS2_ERROR_UNABLE_TO_LAUNCH_ROUND,
	OSIPS2_ERROR_MATCH_NOT_FOUND,									 	
	OSIPS2_ERROR_UNABLE_TO_PARTICIPATE,								 	
	OSIPS2_ERROR_UNABLE_TO_REQUEST_DEFAULT_MATCHES,					 	
	OSIPS2_ERROR_UNABLE_TO_REQUEST_CUSTOM_MATCHES,					 	
	OSIPS2_ERROR_UNABLE_TO_REQUEST_CONNECTION_INFO,					 	
	OSIPS2_ERROR_FAILED_HARDWARE_CONNECTION,						 	
	OSIPS2_ERROR_REQUEST_FETCH_URL_FAILED,		   	
	OSIPS2_ERROR_TIMEOUT_ON_PROCESS_RENDEZVOUS_CALL,				   			 	
	OSIPS2_ERROR_UNABLE_TO_START_ROUND,								 	
	OSIPS2_ERROR_WAITING_TO_START_ROUND,							 	
	OSIPS2_ERROR_UNABLE_TO_FINISH_ROUND,							 	
	OSIPS2_ERROR_WAITING_TO_FINISH_ROUND,							 	
	OSIPS2_ERROR_UNABLE_TO_REPORT_STATS,							 	
	OSIPS2_ERROR_WAITING_TO_REPORT_STATS,							 	
	OSIPS2_ERROR_UNABLE_TO_END_PARTICIPATION,						 	
	OSIPS2_ERROR_WAITING_TO_END_PARTICIPATION,						 	
	OSIPS2_ERROR_UNABLE_TO_FINISH_SESSION,							 	
	OSIPS2_ERROR_WAITING_TO_FINISH_SESSION,							 	
	OSIPS2_ERROR_UNABLE_TO_UNREGISTER_SESSION,						 	
	OSIPS2_ERROR_WAITING_TO_UNREGISTER_SESSION,						 	
	OSIPS2_ERROR_UNABLE_TO_FIND_ROUND_INVITATION,					 	
	OSIPS2_ERROR_UNABLE_TO_INVITE_OPPONENTS,						 	
	OSIPS2_ERROR_UNABLE_TO_REGISTER_EVENT,							 	
	OSIPS2_ERROR_REQUEST_TIMED_OUT,									 	
	OSIPS2_ERROR_UNABLE_TO_CREATE_ACCOUNT,							 	
	OSIPS2_ERROR_REQUEST_FIND_MATCH_BY_ID_FAILED,					 	
	OSIPS2_ERROR_UNABLE_TO_FIND_MATCH_BY_ID,						 	
	OSIPS2_ERROR_REQUEST_INVITE_TO_MATCH_FAILED,					 	
	OSIPS2_ERROR_UNABLE_TO_START_PEER_MANAGER,						 	
	OSIPS2_ERROR_UNABLE_TO_START_NAT_TRAVERSAL,						 	
	OSIPS2_ERROR_UNABLE_TO_REQUEST_FIND_RANKING,					 	
	OSIPS2_ERROR_UNABLE_TO_CREATE_RANKING,							 	
	OSIPS2_ERROR_UNABLE_TO_HOST_COMPETITION,						 	
	OSIPS2_ERROR_UNABLE_TO_REQUEST_UPDATE_STATUS,					 	
	OSIPS2_ERROR_UNABLE_TO_GET_LADDER_STATS,						 	
	OSIPS2_ERROR_UNABLE_TO_GET_NONLADDER_STATS,						 	
	OSIPS2_ERROR_UNABLE_TO_GET_LADDER_RANKING,						 	
	OSIPS2_ERROR_REQUEST_GET_MATCH_INVITES_FAILED,
	OSIPS2_ERROR_REQUEST_FIND_PID_FROM_NAME_FAILED,
	OSIPS2_CLAN_REQUEST_CLAN_CREATE_FAILED,							 	
	OSIPS2_CLAN_REQUEST_CLAN_UPDATE_MY_INFO_FAILED,					 	
	OSIPS2_CLAN_REQUEST_CLAN_JOIN_BY_INVITATION_FAILED,				 	
	OSIPS2_CLAN_REQUEST_CLAN_DENY_INVITATION_FAILED,				 	
	OSIPS2_CLAN_REQUEST_CLAN_BLOCK_INVITATION_FAILED,				 	
	OSIPS2_CLAN_REQUEST_CLAN_SEND_INVITATION_FAILED,				 	
	OSIPS2_CLAN_REQUEST_CLAN_CANCEL_SENT_INVITATION_FAILED,			 	
	OSIPS2_CLAN_REQUEST_CLAN_INVITATION_LIST_FAILED,				 	
	OSIPS2_CLAN_REQUEST_CLAN_ID_LIST_FOR_PLAYER_FAILED,				 	
	OSIPS2_CLAN_REQUEST_CLAN_INFO_LIST_FAILED,						 	
	OSIPS2_CLAN_REQUEST_CLAN_MEMBERSHIP_LIST_FAILED,				 	
	OSIPS2_CLAN_REQUEST_CLAN_LEAVE_FAILED,							 	
	OSIPS2_CLAN_REQUEST_CLAN_NOTICE_LIST_FAILED,					 	
	OSIPS2_CLAN_REQUEST_CLAN_POST_NOTICE_FAILED,					 	
	OSIPS2_CLAN_REQUEST_CLAN_KICK_MEMBER_FAILED,					 	
	OSIPS2_CLAN_REQUEST_CLAN_DEMOTE_MEMBER_FAILED,					 	
	OSIPS2_CLAN_REQUEST_CLAN_PROMOTE_MEMBER_FAILED,					 	
	OSIPS2_CLAN_REQUEST_CLAN_TRANSFER_LEADERSHIP_FAILED,			 	
	OSIPS2_ERROR_REQUEST_FILTER_TEXT_FAILED,
	OSIPS2_ERROR_REQUEST_MESSAGE_OF_THE_DAY_FAILED,
	OSIPS2_ERROR_REQUEST_UPDATE_PLAYER_JOINING_FAILED,
	OSIPS2_ERROR_REQUEST_UPDATE_PLAYER_LEAVING_FAILED,
	OSIPS2_ERROR_FINDING_HOSTED_MATCH,
	OSI_END_TEXT_LIST
};

#endif