#pragma once

///----------------------------------------------------------------------------
//! \brief MatchSearchHelper handles the task of getting the specific details
//! \brief for a match, given only the MatchID/XNKID.  Uses the 
//! \brief CSpecificMatchQuery class generated by MatchSim.
///----------------------------------------------------------------------------
class MatchSearchHelper
{
public:

	MatchSearchHelper();
	~MatchSearchHelper();
	
	//! \brief Purge all tasks and memory used by this class.
	void 
	Reset();

    //! \return True if a search is already underway for the given match.
	bool
	IsAlreadySearchingFor(
		const OSIMatchID& matchID )
	const;
	
	//! \brief Begin a new search.
	void
	AddSearch(
		const OSIMatchID& matchID );

	//! \brief Cancel a search and free its resources.
	void
	CancelSearch(
		const OSIMatchID& matchID );

	//! \brief Call this every frame to pump any tasks that might be active.
	void
	Update();

	//! \brief Get results of search and free its resources.
	//! \return False if the search is still processing.
	bool
	GetSearchResults(
		const OSIMatchID& matchID,
		OSIMatch& results,
		bool& isError );
	
private:

	struct MatchSearch
	{
		MatchSearch( const OSIMatchID& matchID ) 
		: matchID( matchID ),
		  isCompleted( false )
		{
			query.Query( matchID.quadword );
		}

		CSpecificMatchQuery query;
		OSIMatchID matchID;
		bool isCompleted;
	};

	DynamicArray< MatchSearch* > m_searches;
};