//
// ScriptToken.h
//

// null
SCRIPT_TOKEN( TOKEN_NONE,            "NONE",            OPCODE_NOP          )
SCRIPT_TOKEN( TOKEN_ERROR,           "ERROR",           OPCODE_NOP          )

// values
SCRIPT_TOKEN( TOKEN_CONST_INT,       "constant-int",    OPCODE_NOP          )
SCRIPT_TOKEN( TOKEN_CONST_FLOAT,     "constant-float",  OPCODE_NOP          )
SCRIPT_TOKEN( TOKEN_CONST_HEX,       "constant-hex",    OPCODE_NOP          )
SCRIPT_TOKEN( TOKEN_STRING,          "string",          OPCODE_NOP          )
SCRIPT_TOKEN( TOKEN_IDENT,           "identifier",      OPCODE_NOP          )

// compare
SCRIPT_TOKEN( TOKEN_LESS_THAN,       "<",               OPCODE_LESS_THAN    )
SCRIPT_TOKEN( TOKEN_LESS_THAN_EQUAL, "<=",              OPCODE_LESS_THAN_EQ )
SCRIPT_TOKEN( TOKEN_GTR_THAN,        ">",               OPCODE_GTR_THAN     )
SCRIPT_TOKEN( TOKEN_GTR_THAN_EQUAL,  ">=",              OPCODE_GTR_THAN_EQ  )
SCRIPT_TOKEN( TOKEN_EQUALS,          "==",              OPCODE_EQUAL        )
SCRIPT_TOKEN( TOKEN_NOT_EQUALS,      "!=",              OPCODE_NOT_EQUAL    )

// arithmetic
SCRIPT_TOKEN( TOKEN_PLUS,            "PLUS",            OPCODE_ADD          )
SCRIPT_TOKEN( TOKEN_MINUS,           "MINUS",           OPCODE_SUB          )
SCRIPT_TOKEN( TOKEN_UNARY_MINUS,     "UNARY_MINUS",     OPCODE_NEGATE       )
SCRIPT_TOKEN( TOKEN_MULT,            "MULT",            OPCODE_MULT         )
SCRIPT_TOKEN( TOKEN_DIV,             "DIV",             OPCODE_DIV          )
SCRIPT_TOKEN( TOKEN_MOD,             "MOD",             OPCODE_MOD          )
SCRIPT_TOKEN( TOKEN_SHIFT_L,         "SHIFT_L",         OPCODE_SHIFT_L      )
SCRIPT_TOKEN( TOKEN_SHIFT_R,         "SHIFT_R",         OPCODE_SHIFT_R      )
SCRIPT_TOKEN( TOKEN_LOGICAL_AND,     "LOGICAL_AND",     OPCODE_LOGICAL_AND  )
SCRIPT_TOKEN( TOKEN_LOGICAL_OR,      "LOGICAL_OR",      OPCODE_LOGICAL_OR   )
SCRIPT_TOKEN( TOKEN_LOGICAL_NOT,     "LOGICAL_NOT",     OPCODE_LOGICAL_NOT  )
SCRIPT_TOKEN( TOKEN_BITWISE_OR,      "BITWISE_OR",      OPCODE_BITWISE_OR   )
SCRIPT_TOKEN( TOKEN_BITWISE_AND,     "BITWISE_AND",     OPCODE_BITWISE_AND  )
SCRIPT_TOKEN( TOKEN_BITWISE_XOR,     "BITWISE_XOR",     OPCODE_BITWISE_XOR  )
SCRIPT_TOKEN( TOKEN_BITWISE_NOT,     "BITWISE_NOT",     OPCODE_BITWISE_NOT  )
SCRIPT_TOKEN( TOKEN_INCREMENT,       "++",              OPCODE_ADD          )
SCRIPT_TOKEN( TOKEN_DECREMENT,       "--",              OPCODE_SUB          )
SCRIPT_TOKEN( TOKEN_PLUS_EQUALS,     "+=",              OPCODE_ADD          )
SCRIPT_TOKEN( TOKEN_MINUS_EQUALS,    "-=",              OPCODE_SUB          )
SCRIPT_TOKEN( TOKEN_MULT_EQUALS,     "*=",              OPCODE_MULT         )
SCRIPT_TOKEN( TOKEN_DIV_EQUALS,      "/=",              OPCODE_DIV          )
SCRIPT_TOKEN( TOKEN_MOD_EQUALS,      "%=",              OPCODE_MOD			 )
SCRIPT_TOKEN( TOKEN_SHIFT_L_EQUALS,  "<<=",             OPCODE_SHIFT_L		 )
SCRIPT_TOKEN( TOKEN_SHIFT_R_EQUALS,  ">>=",             OPCODE_SHIFT_R		 )
SCRIPT_TOKEN( TOKEN_AND_EQUALS,      "&=",              OPCODE_BITWISE_AND  )
SCRIPT_TOKEN( TOKEN_OR_EQUALS,       "|=",              OPCODE_BITWISE_OR   )
SCRIPT_TOKEN( TOKEN_XOR_EQUALS,      "^=",              OPCODE_BITWISE_XOR  )
SCRIPT_TOKEN( TOKEN_ABS,             "ABS",             OPCODE_ABS          )

// lexical
SCRIPT_TOKEN( TOKEN_ASSIGN,          "=",               OPCODE_NOP          )
SCRIPT_TOKEN( TOKEN_PAREN_L,         "(",               OPCODE_NOP          )
SCRIPT_TOKEN( TOKEN_PAREN_R,         ")",               OPCODE_NOP          )
SCRIPT_TOKEN( TOKEN_BRACKET_L,       "[",               OPCODE_NOP          )
SCRIPT_TOKEN( TOKEN_BRACKET_R,       "]",               OPCODE_NOP          )
SCRIPT_TOKEN( TOKEN_BRACE_L,         "{",               OPCODE_NOP          )
SCRIPT_TOKEN( TOKEN_BRACE_R,         "}",               OPCODE_NOP          )
SCRIPT_TOKEN( TOKEN_COLON,           ":",               OPCODE_NOP          )
SCRIPT_TOKEN( TOKEN_SEMICOLON,       ";",               OPCODE_NOP          )
SCRIPT_TOKEN( TOKEN_COMMA,           ",",               OPCODE_NOP          )
SCRIPT_TOKEN( TOKEN_QUESTION_MARK,   "?",               OPCODE_NOP          )
SCRIPT_TOKEN( TOKEN_DOTDOTDOT,       "...",             OPCODE_NOP          )

// reserved words
SCRIPT_TOKEN( TOKEN_IF,              "IF",              OPCODE_NOP          )
SCRIPT_TOKEN( TOKEN_ELSE,            "ELSE",            OPCODE_NOP          )
SCRIPT_TOKEN( TOKEN_WHILE,           "WHILE",           OPCODE_NOP          )
SCRIPT_TOKEN( TOKEN_FOR,             "FOR",             OPCODE_NOP          )
SCRIPT_TOKEN( TOKEN_INT_DECL,        "INT_DECL",        OPCODE_NOP          )
SCRIPT_TOKEN( TOKEN_FLOAT_DECL,      "FLOAT_DECL",      OPCODE_NOP          )
SCRIPT_TOKEN( TOKEN_VOID_DECL,       "VOID_DECL",       OPCODE_NOP          )
SCRIPT_TOKEN( TOKEN_STRING_DECL,     "STRING_DECL",     OPCODE_NOP          )
SCRIPT_TOKEN( TOKEN_STRUCT_DECL,     "STRUCT_DECL",     OPCODE_NOP          )
SCRIPT_TOKEN( TOKEN_GOTO,            "GOTO",            OPCODE_NOP          )
SCRIPT_TOKEN( TOKEN_PRINT,           "PRINT",           OPCODE_PRINT        )
SCRIPT_TOKEN( TOKEN_SLEEP,           "SLEEP",           OPCODE_SLEEP        )
SCRIPT_TOKEN( TOKEN_RETURN,          "RETURN",          OPCODE_RETURN       )
SCRIPT_TOKEN( TOKEN_EXTERN,          "EXTERN",          OPCODE_NOP          )
SCRIPT_TOKEN( TOKEN_ENUM,            "ENUM",            OPCODE_NOP          )
SCRIPT_TOKEN( TOKEN_DO,              "DO",              OPCODE_NOP          )
SCRIPT_TOKEN( TOKEN_BREAK,           "BREAK",           OPCODE_NOP          )
SCRIPT_TOKEN( TOKEN_CONTINUE,        "CONTINUE",        OPCODE_NOP          )
SCRIPT_TOKEN( TOKEN_SIZEOF,          "SIZEOF",          OPCODE_NOP          )
SCRIPT_TOKEN( TOKEN_SWITCH,          "SWITCH",          OPCODE_NOP          )
SCRIPT_TOKEN( TOKEN_CASE,            "CASE",            OPCODE_NOP          )
SCRIPT_TOKEN( TOKEN_DEFAULT,         "DEFAULT",         OPCODE_NOP          )
SCRIPT_TOKEN( TOKEN_THIS,            "THIS",            OPCODE_NOP		    )
SCRIPT_TOKEN( TOKEN_STATIC,          "STATIC",          OPCODE_NOP          )

// parse tree
SCRIPT_TOKEN( TOKEN_GROUP,           "GROUP",           OPCODE_NOP          )
SCRIPT_TOKEN( TOKEN_ARG,             "ARG",             OPCODE_NOP          )
SCRIPT_TOKEN( TOKEN_EXPR_LIST,       "EXPR LIST",       OPCODE_NOP          )
SCRIPT_TOKEN( TOKEN_STATEMENT_EXPR,  "STATEMENT_EXPR",  OPCODE_NOP          )
SCRIPT_TOKEN( TOKEN_LABEL,           "LABEL",           OPCODE_NOP          )
SCRIPT_TOKEN( TOKEN_SCOPE_BEGIN,     "SCOPE_BEGIN",     OPCODE_NOP          )
SCRIPT_TOKEN( TOKEN_FUNC_DECL,       "FUNCTION DEFINE", OPCODE_NOP			 )
SCRIPT_TOKEN( TOKEN_FUNC_CALL,       "FUNCTION CALL",   OPCODE_NOP			 )
SCRIPT_TOKEN( TOKEN_POST_INCREMENT,  "POST INC",        OPCODE_ADD			 )
SCRIPT_TOKEN( TOKEN_POST_DECREMENT,  "POST DEC",        OPCODE_SUB          )
SCRIPT_TOKEN( TOKEN_LIST_ASSIGN,     "LIST ASSIGN",	  OPCODE_NOP          )
SCRIPT_TOKEN( TOKEN_COND_EXPR,       "COND EXPR",       OPCODE_NOP          )
SCRIPT_TOKEN( TOKEN_VARIABLE,        "VARIABLE",        OPCODE_NOP          )
SCRIPT_TOKEN( TOKEN_FUNCTION,        "FUNCTION",        OPCODE_NOP          )
