////////////////////////////////////////////////////////////////////////////
//
// TupperwareLog
//
// A class for tupperware verbosity.
//
////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////

#ifndef TUPPERWARELOG_H
#define TUPPERWARELOG_H

////////////////////////////////////////////////////////////////////////////

#include <stdarg.h>
#include <stdio.h>

////////////////////////////////////////////////////////////////////////////

#define TUPPERWARE_LOG_FILE_NAME	"tupperware.log"

////////////////////////////////////////////////////////////////////////////

typedef void ( *TupperwareLogCB )( const char* );

////////////////////////////////////////////////////////////////////////////

class TupperwareLog {
public:
	TupperwareLog();
	~TupperwareLog();

	// Write (a formatted string ala printf) to the log file.
	static void Write( const char* format, ... );

	// Register a callback that will be called with the string generated
	// when Write() is called.
	static void OnWrite( TupperwareLogCB on_write );

private:

	// Return a string formatted ala printf.
	char* GetFormattedString( const char* format, va_list args );

private:
	char* m_Buffer;				// "Static" buffer for formatting writes.
	int m_BufferSize;				// Size (in bytes) of m_Buffer.
	TupperwareLogCB m_WriteCB;	// Write() callback.
};

////////////////////////////////////////////////////////////////////////////

#endif
