///////////////////////////////////////////////////////////////////////////////
// A stationary Cam
///////////////////////////////////////////////////////////////////////////////
#include "camera/CameraPCH.h"

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
StationaryWTVC::StationaryWTVC()
{
	m_localTarget.Clear();
	SetTarget(&m_localTarget);
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
void StationaryWTVC::Setup(const Vector3 &eye, const Vector3 &target)
{
	m_eye = eye;
	m_localTarget = target;
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
void StationaryWTVC::SetLocalTarget(const Vector3 &target)
{ 
	m_localTarget = target; 
	SetTarget(&m_localTarget);  
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
StationaryProjection::StationaryProjection()
{
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
void StationaryProjection::Update( Camera &parent )
{
//	SetHither( .1 , true);

	DefaultProjectionController::Update(parent);
}

///////////////////////////////////////////////////////////////////////////////
// Cameras must have at least a name and w2v controller
///////////////////////////////////////////////////////////////////////////////

StationaryCamera::StationaryCamera( const char *name , ViewportController *viewportC) 
								: Camera( name , &m_stationary, &m_stationaryProj , viewportC ) , m_stationaryProj()
{
	SetEyePointFilter(0.0f);
	SetFocalPointFilter(0.0f);
}

//StationaryCamera::StationaryCamera(
//const char *name,
//ProjectionController *projectionC,
//ViewportController *viewportC) :
//Camera(name, &m_stationary, projectionC, viewportC)
//{
//	SetEyePointFilter(0.0f);
//	SetFocalPointFilter(0.0f);
//}


