///////////////////////////////////////////////////////////////////////////////
// A simple, default projection
///////////////////////////////////////////////////////////////////////////////
#include "camera/CameraPCH.h"
#include "Math/sfilter.h"

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
DefaultProjectionController::DefaultProjectionController()
{
	m_hither = m_hitherTarget = 0.1f;
	m_yon = m_yonTarget = 150.0f;
	m_hitherYonFilterT = 0.01f;

	m_FOV = m_FOVTarget = 65.0f;
	m_FOVFilterT = 0.1f;

	#if defined (_XBOX)
	if (DirectX_PresentParams.Flags & D3DPRESENTFLAG_WIDESCREEN)
		m_aspectRatio = m_aspectRatioTarget = 16.0f / 9.0f;
	else
		m_aspectRatio = m_aspectRatioTarget = 4.0f / 3.0f;
	#else
	m_aspectRatio = m_aspectRatioTarget = 4.0f / 3.0f;
	#endif

	m_aspectRatioFilterT = 0.1f;
}

///////////////////////////////////////////////////////////////////////////////
// Control hither and yon
///////////////////////////////////////////////////////////////////////////////
void DefaultProjectionController::SetHitherYon(
float hither,
float yon,
bool instant)
{
	ASSERT(hither >= 0.0f);
	ASSERT(yon >= 0.0f);
	ASSERT(hither < yon);

	m_hitherTarget = hither;
	m_yonTarget = yon;
	if (instant)
	{
		m_hither = m_hitherTarget;
		m_yon = m_yonTarget;
	}
}

///////////////////////////////////////////////////////////////////////////////
// Control hither
///////////////////////////////////////////////////////////////////////////////
void DefaultProjectionController::SetHither(
float hither,
bool instant)
{
	ASSERT(hither >= 0.0f);
	ASSERT(hither < m_yon);

	m_hitherTarget = hither;
	if (instant)
		m_hither = m_hitherTarget;
}

///////////////////////////////////////////////////////////////////////////////
// Control hither
///////////////////////////////////////////////////////////////////////////////
void DefaultProjectionController::SetYon(
float yon,
bool instant)
{
	ASSERT(yon >= 0.0f);
	ASSERT(m_yon > m_hither);

	m_yonTarget = yon;
	if (instant)
		m_yon = m_yonTarget;
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
void DefaultProjectionController::SetHitherYonFilter(
float filterT)
{
	m_hitherYonFilterT = filterT;
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
float DefaultProjectionController::Hither()
{
	return m_hither;
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
float DefaultProjectionController::Yon()
{
	return m_yon;
}

///////////////////////////////////////////////////////////////////////////////
// FOV (0..1) (non inclusive) for 0 to 180 degrees
///////////////////////////////////////////////////////////////////////////////
void DefaultProjectionController::SetFOV(
float fov,
bool instant)
{
	ASSERT(fov > 0.0f && fov < 180.0f);

	m_FOVTarget = fov;
	if (instant)
		m_FOV = m_FOVTarget;
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
void DefaultProjectionController::SetFOVFilter(
float filterT)
{
	m_FOVFilterT = filterT;
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
float DefaultProjectionController::FOV()
{
	return m_FOV;
}

///////////////////////////////////////////////////////////////////////////////
// Return the aspect ratio
///////////////////////////////////////////////////////////////////////////////
void DefaultProjectionController::SetAspectRatio(
float aspectRatio,
bool instant)
{
	ASSERT(aspectRatio > 0.0f);

	m_aspectRatioTarget = aspectRatio;
	if (instant)
		m_aspectRatio = m_aspectRatioTarget;
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
float DefaultProjectionController::AspectRatio()
{
	return m_aspectRatio;
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
void DefaultProjectionController::SetAspectRatioFilter(
float filterT)
{
	m_aspectRatioFilterT = filterT;
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
void DefaultProjectionController::Update(
Camera &parent)
{
	float deltaT = g_timer.GetFrameSec();

	m_hither = FOFilterImplicit(m_hither, m_hitherTarget, deltaT, m_hitherYonFilterT);
	m_yon = FOFilterImplicit(m_yon, m_yonTarget, deltaT, m_hitherYonFilterT);

	m_FOV = FOFilterImplicit(m_FOV, m_FOVTarget, deltaT, m_FOVFilterT);

	m_aspectRatio = FOFilterImplicit(m_aspectRatio, m_aspectRatioTarget, deltaT, m_aspectRatioFilterT);
}

