///////////////////////////////////////////////////////////////////////////////
// A simple Target cam
///////////////////////////////////////////////////////////////////////////////
#include "camera/CameraPCH.h"

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
GeneralWTVC::GeneralWTVC()
{
	Setup ( Vector3 (2.0f, 1.0f, 0.0f),
			  Vector3 (0.0f, 1.0f, 0.0f) );
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
void GeneralWTVC::Setup(const Vector3 &Pos, const Vector3 &Target)
{
	SetEye(Pos);
	SetFocalPoint(Target);
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
void GeneralWTVC::Update( Camera &parent )
{
	GeneralCamera	&generalCam = ((GeneralCamera &)parent);
	if( generalCam.GetMode() == GeneralCamera::CAMMODE_FOCAL_DIRECTION )
	{
		m_focalPoint = Eye();
		m_focalPoint += generalCam.GetDirection();
	}
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
GeneralProjection::GeneralProjection()
{
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
void GeneralProjection::Update( Camera &parent )
{
//	SetHither( .1 , true);

	DefaultProjectionController::Update(parent);
}

///////////////////////////////////////////////////////////////////////////////
// Cameras must have at least a name and w2v controller
///////////////////////////////////////////////////////////////////////////////
GeneralCamera::GeneralCamera( const char *name , ViewportController *viewportC) 
								: Camera( name , &m_target , &m_generalProj , viewportC ) , m_generalProj()
{
//	m_generalProj.SetHither( .5 , true );
}

GeneralCamera::GeneralCamera( const char *name , WorldToViewController *worldToViewC, ProjectionController *projectionC, ViewportController *viewportC )
								: Camera(name , worldToViewC, projectionC, viewportC )
{
}
