///////////////////////////////////////////////////////////////////////////////
// A simple orbit cam (proof of concept)
///////////////////////////////////////////////////////////////////////////////
#include "camera/CameraPCH.h"

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
OrbitWTVC::OrbitWTVC()
{
	Setup(2.0f, 2.0f, 30.0f);
	m_angle = 0.0f;
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
void OrbitWTVC::Setup(
float distance,
float height,
float rotationSpeed)
{
	m_distance = distance;
	m_height = height;
	m_rotationSpeed = Math::Deg2Rad(rotationSpeed);
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
void OrbitWTVC::Update(
Camera &parent)
{
	// Update the angle
	m_angle += m_rotationSpeed * g_timer.GetFrameSec();

	// Make a vector out of the angle in xz
	float s, c;
	Math::SinCos(m_angle, s, c);
 	Vector3 dir(s, 0.0f, c);;

	// Compute the eye!
	m_eye = FocalPoint() +
				(m_height * Up()) +
				(m_distance * dir);
}

///////////////////////////////////////////////////////////////////////////////
// Cameras must have at least a name and w2v controller
///////////////////////////////////////////////////////////////////////////////
OrbitCamera::OrbitCamera(
const char *name,
ProjectionController *projectionC,
ViewportController *viewportC) :
Camera(name, &m_orbit, projectionC, viewportC)
{
}

