///////////////////////////////////////////////////////////////////////////////
// A simple Target cam
///////////////////////////////////////////////////////////////////////////////
#include "camera/CameraPCH.h"

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
TargetWTVC::TargetWTVC()
{
	Setup ( Vector3 (2.0f, 1.0f, 0.0f),
			  Vector3 (0.0f, 1.0f, 0.0f) );

	m_focalPoint = m_Target;
	m_eye = m_Pos;}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
void TargetWTVC::Setup(Vector3 Pos, Vector3 Target)
{
	m_Pos = Pos;
	m_Target = Target;
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
void TargetWTVC::Update(Camera &parent)
{
	m_focalPoint = m_Target;

	// Compute the eye!
	m_eye = m_Pos;
}

///////////////////////////////////////////////////////////////////////////////
// Cameras must have at least a name and w2v controller
///////////////////////////////////////////////////////////////////////////////
TargetCamera::TargetCamera(
const char *name,
ProjectionController *projectionC,
ViewportController *viewportC) :
Camera(name, &m_target, projectionC, viewportC)
{
}

