///////////////////////////////////////////////////////////////////////////////
// the flexible target W2V controller
///////////////////////////////////////////////////////////////////////////////
#include "camera/CameraPCH.h"

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
FlexTargetW2VC::FlexTargetW2VC()
{
	m_type = NONE;
	m_actor = NULL;
	m_point = NULL;
	m_offset.Clear();
}

///////////////////////////////////////////////////////////////////////////////
// Follow this actor
///////////////////////////////////////////////////////////////////////////////
void FlexTargetW2VC::SetTarget(
CActor *actor,
bool useFocus)
{
	if (!actor)
		m_type = NONE;
	else
	{
		m_type = useFocus ? ACTORFOCUS : ACTORBODY;
		m_actor = actor;
	}
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
void FlexTargetW2VC::SetTarget(
const Vector3 *target)
{
	if (!target)
		m_type = NONE;
	else
	{
		m_type = POINT;
		m_point = target;
	}
}

///////////////////////////////////////////////////////////////////////////////
// Get the target
///////////////////////////////////////////////////////////////////////////////
CActor *FlexTargetW2VC::GetActorTarget()
{
	if (m_type == ACTORBODY || m_type == ACTORFOCUS)
		return m_actor;
	else
		return NULL;
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
const Vector3 *FlexTargetW2VC::GetPointTarget()
{
	if (m_type == POINT)
		return m_point;
	else
		return NULL;
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
void FlexTargetW2VC::ClearTarget()
{
	m_type = NONE;
}

///////////////////////////////////////////////////////////////////////////////
// What type of target is there?
///////////////////////////////////////////////////////////////////////////////
FlexTargetW2VC::Type FlexTargetW2VC::TargetType()
{
	return m_type;
}

///////////////////////////////////////////////////////////////////////////////
// Set an offset to the target
///////////////////////////////////////////////////////////////////////////////
void FlexTargetW2VC::SetOffset(
const Vector3 &offset)
{
	m_offset = offset;
}

///////////////////////////////////////////////////////////////////////////////
// Return the focal point
///////////////////////////////////////////////////////////////////////////////
Vector3 FlexTargetW2VC::FocalPoint()
{
	switch (m_type)
	{
		case POINT:
			ASSERT(m_point);
			return *m_point + m_offset;
			break;

		case ACTORFOCUS:
			ASSERT(m_actor);
			return m_actor->GetFocusInWorld();
			break;

		case ACTORBODY:
			ASSERT(m_actor);
			return (m_offset * m_actor->GetBodyToWorld() + m_actor->GetBodyInWorld());
			break;

		default:
		case NONE:
			return m_offset;
			break;
	};
}

///////////////////////////////////////////////////////////////////////////////
// Return an approximate up
///////////////////////////////////////////////////////////////////////////////
Vector3 FlexTargetW2VC::Up()
{
	switch (m_type)
	{
		case ACTORFOCUS:
		case ACTORBODY:
			ASSERT(m_actor);
			return m_actor->GetBodyToWorld().GetRow1();
			break;

		default:
			return Vector3(0.0f, 1.0f, 0.0f);
			break;
	};
}





