///////////////////////////////////////////////////////////////////////////////
// Terrain collide databases are now packed together by layers
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
// What is this layer's mask
///////////////////////////////////////////////////////////////////////////////
inline unsigned int TerrainCollideLayer::Mask()
{
	return m_mask;
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
inline bool TerrainCollideLayer::MatchMask(
unsigned int mask)
{
	return (m_mask & mask) != 0;
}

///////////////////////////////////////////////////////////////////////////////
// Get at the bounding info
///////////////////////////////////////////////////////////////////////////////
inline const AABB &TerrainCollideLayer::Bounds()
{
	return m_hdr->bounds;
}

///////////////////////////////////////////////////////////////////////////////
// Get at the triangle list
///////////////////////////////////////////////////////////////////////////////
inline int TerrainCollideLayer::Triangles()
{
	return m_hdr->triangles;
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
inline TerrainTriangle *TerrainCollideLayer::TriangleList()
{
	return m_triangle;
}

///////////////////////////////////////////////////////////////////////////////
// Get at the oct tree info
///////////////////////////////////////////////////////////////////////////////
inline const Octant &TerrainCollideLayer::RootOctant()
{
	return m_hdr->rootOctant;
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
inline OctTreeNode *TerrainCollideLayer::Root()
{
	return m_root;
}


///////////////////////////////////////////////////////////////////////////////
// What is the leaf depth of this tree?
///////////////////////////////////////////////////////////////////////////////
inline uint TerrainCollideLayer::LeafDepth()
{
	return m_hdr->leafDepth;
}

///////////////////////////////////////////////////////////////////////////////
// Access the test ID
///////////////////////////////////////////////////////////////////////////////
inline OctTreeTestID &TerrainCollideLayer::TestID()
{
	return m_testID;
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
inline u32 TerrainCollideLayer::NewTestID()
{
	return m_testID.GetNewID();
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
inline u32 TerrainCollideLayer::CurrentTestID()
{
	return m_testID.CurrentID();
}

///////////////////////////////////////////////////////////////////////////////
// Get at the validation stuff
///////////////////////////////////////////////////////////////////////////////
inline TriangleSuspect &TerrainCollideLayer::Suspect()
{
	return m_suspect;
}
