/////////////////////////////////////////////////////////////////////////////
// Simple stack template
//
// These stacks never deal with constructors/destructors so BEWARE!
/////////////////////////////////////////////////////////////////////////////
#include "Layers/Debug.h"
#include "platform/BaseType.h"

/////////////////////////////////////////////////////////////////////////////
// Really simple stack that uses a preallocated array
// Note if you use T's (not T*'s) make sure the copy constructor is
// supported.
/////////////////////////////////////////////////////////////////////////////
template <class T, int maxItems>
inline SimpleStack<T, maxItems>::SimpleStack()
{
	top = 0;
}

/////////////////////////////////////////////////////////////////////////////
// Push a new item onto the stack
/////////////////////////////////////////////////////////////////////////////
template <class T, int maxItems>
inline void SimpleStack<T, maxItems>::Push(
T &newTop)
{
	// Test for overflow
	ASSERT(top < maxItems);
	if (top < maxItems)
		stack[top++] = newTop;
}

/////////////////////////////////////////////////////////////////////////////
// Pop an item off the stack
/////////////////////////////////////////////////////////////////////////////
template <class T, int maxItems>
inline T SimpleStack<T, maxItems>::Pop()
{
	// Doh!
	ASSERT(top > 0);

	// try not to crash
	if (--top < 0)
		top = 0;

	return stack[top];
}

/////////////////////////////////////////////////////////////////////////////
// Peek at the top item (without removing it)
/////////////////////////////////////////////////////////////////////////////
template <class T, int maxItems>
inline T &SimpleStack<T, maxItems>::Peek()
{
	// Doh!
	ASSERT(top > 0);

	// Give it to 'em
	return (top > 0) ? stack[top - 1] : stack[0];
}

/////////////////////////////////////////////////////////////////////////////
// Is the stack empty?
/////////////////////////////////////////////////////////////////////////////
template <class T, int maxItems>
inline bool SimpleStack<T, maxItems>::Empty()
{
	return (top == 0);
}

/////////////////////////////////////////////////////////////////////////////
// How many items are on the stack?
/////////////////////////////////////////////////////////////////////////////
template <class T, int maxItems>
inline int SimpleStack<T, maxItems>::Items()
{
	return top;
}

/////////////////////////////////////////////////////////////////////////////
// Clear the stack
/////////////////////////////////////////////////////////////////////////////
template <class T, int maxItems>
inline void SimpleStack<T, maxItems>::Clear()
{
	top = 0;
}

/////////////////////////////////////////////////////////////////////////////
// Remove an item from the tack
/////////////////////////////////////////////////////////////////////////////
template <class T, int maxItems>
inline void SimpleStack<T, maxItems>::Remove(int index)
{
	ASSERT(index >= 0 && index < top);

	// Blast it down
	if (index >= 0 && index < top - 1)
		memcpy(&stack[index], &stack[index + 1], (top - index - 1) * sizeof(T));

	// one less item
	if (--top < 0)
		top = 0;
}

/////////////////////////////////////////////////////////////////////////////
// Get at the stack
/////////////////////////////////////////////////////////////////////////////
template <class T, int maxItems>
inline T &SimpleStack<T, maxItems>::Peek(int index)
{
	return stack[index];
}

/////////////////////////////////////////////////////////////////////////////
// Really simple stack that uses a dyanmic array
// Note if you use T's (not T*'s) make sure the copy constructor is
// supported.
/////////////////////////////////////////////////////////////////////////////
template <class T>
inline DynamicStack<T>::DynamicStack(
int startItems,
int growBy) :
stack(startItems, growBy)
{
}

/////////////////////////////////////////////////////////////////////////////
// Push a new item onto the stack
/////////////////////////////////////////////////////////////////////////////
template <class T>
inline void DynamicStack<T>::Push(
T &newTop)
{
	// Add it
	bool ret = stack.Add(newTop);

	// Make sure it worked
	ASSERT(ret);
}

/////////////////////////////////////////////////////////////////////////////
// Pop an item off the stack
/////////////////////////////////////////////////////////////////////////////
template <class T>
inline T DynamicStack<T>::Pop()
{
	// Doh!
	ASSERT(stack.Count() > 0);

	// What is the top?
	int top = stack.Count() - 1;

	// Get it
	T ret = stack[top];

	// Delete it
	stack.Delete(top);

	// Give it back
	return ret;
}

/////////////////////////////////////////////////////////////////////////////
// Peek at the top item (without removing it)
/////////////////////////////////////////////////////////////////////////////
template <class T>
inline T &DynamicStack<T>::Peek()
{
	// Doh!
	ASSERT(stack.Count() > 0);

	// What is the top?
	int top = stack.Count() - 1;

	// Get it
	return stack[top];
}

/////////////////////////////////////////////////////////////////////////////
// Is the stack empty?
/////////////////////////////////////////////////////////////////////////////
template <class T>
inline bool DynamicStack<T>::Empty()
{
	return (stack.Count() == 0);
}

/////////////////////////////////////////////////////////////////////////////
// How many items are on the stack?
/////////////////////////////////////////////////////////////////////////////
template <class T>
inline int DynamicStack<T>::Items()
{
	return stack.Count();
}

/////////////////////////////////////////////////////////////////////////////
// Clear the stack
/////////////////////////////////////////////////////////////////////////////
template <class T>
inline void DynamicStack<T>::Clear()
{
	stack.Clear();
}

/////////////////////////////////////////////////////////////////////////////
// Remove an item from the tack
/////////////////////////////////////////////////////////////////////////////
template <class T>
inline void DynamicStack<T>::Remove(int index)
{
	// Blast it down
	stack.Delete(index);
}

/////////////////////////////////////////////////////////////////////////////
// Get at the stack
/////////////////////////////////////////////////////////////////////////////
template <class T>
inline T &DynamicStack<T>::Peek(int index)
{
	return stack[index];
}



